/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.common.cache.codec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class FastjsonCodec
extends BaseCodec {
    public static final FastjsonCodec INSTANCE;
    private final Encoder encoder = new Encoder(){

        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream os = new ByteBufOutputStream(out);
                JSON.writeJSONString((OutputStream)os, (Object)in, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
                ByteBuf byteBuf = os.buffer();
                return byteBuf;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                out.release();
            }
        }
    };
    private final Decoder<Object> decoder = new Decoder<Object>(){

        public Object decode(ByteBuf buf, State state) throws IOException {
            return JSON.parseObject((InputStream)new ByteBufInputStream(buf), Object.class, (Feature[])new Feature[0]);
        }
    };

    public FastjsonCodec() {
    }

    public FastjsonCodec(ClassLoader classLoader) {
        this();
    }

    public FastjsonCodec(ClassLoader classLoader, FastjsonCodec codec) {
        this();
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }

    static {
        ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
        INSTANCE = new FastjsonCodec();
    }
}

