/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business.modules.developeraccount.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.consts.CodeMessageConsts;
import com.bizvane.openapi.business.modules.developeraccount.entity.OpenapiDeveloperAccount;
import com.bizvane.openapi.business.modules.developeraccount.enums.DeveloperAccountTypeEnum;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountManager;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.common.utils.GeneratorUtils;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpenapiDeveloperAccountManagerImpl
implements OpenapiDeveloperAccountManager {
    @Autowired
    OpenapiDeveloperAccountService developerAccountService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public OpenapiDeveloperAccount applyToDeveloper() {
        return this.applyToDeveloperAccount(DeveloperAccountTypeEnum.developer);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public OpenapiDeveloperAccount applyToProvider() {
        return this.applyToDeveloperAccount(DeveloperAccountTypeEnum.provider);
    }

    private OpenapiDeveloperAccount applyToDeveloperAccount(DeveloperAccountTypeEnum type) {
        if (type == DeveloperAccountTypeEnum.provider) {
            OpenapiDeveloperAccount one = (OpenapiDeveloperAccount)this.developerAccountService.getOne((Wrapper)new QueryWrapper().eq((Object)"type", (Object)type));
            Assert.isTrue((one == null ? 1 : 0) != 0, (CodeMessage)(type == DeveloperAccountTypeEnum.provider ? CodeMessageConsts.Business.PROVIDER_EXIST : CodeMessageConsts.Business.DEVELOPER_EXIST));
        }
        String appkey = GeneratorUtils.uuid();
        String appSecret = GeneratorUtils.md5DigestAsHex((String)appkey);
        OpenapiDeveloperAccount entity = new OpenapiDeveloperAccount();
        entity.setAppKey(appkey);
        entity.setAppSecret(appSecret);
        entity.setType(type);
        entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
        this.developerAccountService.save(entity);
        return entity;
    }

    @Override
    public OpenapiDeveloperAccount get(String id) {
        return (OpenapiDeveloperAccount)this.developerAccountService.getById((Serializable)((Object)id));
    }

    @Override
    public IPage<OpenapiDeveloperAccount> pageDeveloperAccount(Page<OpenapiDeveloperAccount> p, QueryWrapper<OpenapiDeveloperAccount> wrapper) {
        return this.developerAccountService.page((IPage)p, (Wrapper)wrapper);
    }

    @Override
    public List<OpenapiDeveloperAccount> listDeveloperAccount() {
        return this.developerAccountService.list();
    }

    @Override
    public OpenapiDeveloperAccount getDeveloperAccount(String appKey) {
        OpenapiDeveloperAccount developerAccount = (OpenapiDeveloperAccount)this.developerAccountService.getOne((Wrapper)new QueryWrapper().eq((Object)"app_key", (Object)appKey));
        return developerAccount;
    }

    @Override
    public OpenapiDeveloperAccount getProviderDeveloperAccount(String businessId) {
        OpenapiDeveloperAccount one = (OpenapiDeveloperAccount)this.developerAccountService.getOne((Wrapper)new QueryWrapper().eq((Object)"type", (Object)"provider"));
        return one;
    }
}

