package com.bizvane.openapi.business.modules.test.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApi;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApiRequestParams;

/**
 * 
 * @author wang.zeyan
 *  2019年5月9日
 */
public interface OpenapiTestApiManager {

	
	/**
	 * 执行测试,不创建测试信息
	 * @param apiId
	 * @param params
	 * @return
	 */
	Object executeTest(String apiId, Map<String, Object> params, String businessId);
	/**
	 * 执行测试
	 * @param testApiId
	 * @return
	 */
	Object executeTest(String testApiId);
	
	/**
	 * 添加测试信息
	 * @param entity
	 * @param apiId
	 * @return
	 */
	boolean addTest(OpenapiTestApi entity, String apiId);
	
	/**
	 * 修改测试信息
	 * @param entity
	 * @param id
	 * @return
	 */
	boolean updateTest(OpenapiTestApi entity, String id);
	
	/**
	 * 删除单个接口下所以测试请求参数信息
	 * @param apiId
	 * @return
	 */
	boolean deleteTestApiRequestParamsByApiId(String apiId);
	
	/**
	 * 根据ID获取测试信息
	 * @param id
	 * @return
	 */
	OpenapiTestApi getTest(String id);
	
	/**
	 * 添加测试接口参数信息
	 * @param entity
	 * @param testApiId
	 * @return
	 */
	boolean addTestApiRequestParams(OpenapiTestApiRequestParams entity, String testApiId);

	/**
	 * 修改测试接口参数信息
	 * @param entity
	 * @param id
	 * @return
	 */
	boolean updateTestApiRequestParams(OpenapiTestApiRequestParams entity, String id);

	/**
	 * 获取测试所以接口参数信息
	 * @param testApiId
	 * @return
	 */
	List<OpenapiTestApiRequestParams> getTestApiRequestParams(String testApiId);

	/**
	 * 删除测试接口参数信息
	 * @param id
	 * @return
	 */
	boolean deleteTestApiRequestParams(String id);

	/**
	 * 删除测试接口信息
	 * @param id
	 * @return
	 */
	boolean deleteTestApi(String id);

	/**
	 * 删除当前apiId下所有测试接口信息
	 * @param apiId
	 * @return
	 */
	boolean deleteAllTestApi(String apiId);

	/**
	 * 分页查询apiId下测试接口信息
	 * @param p
	 * @param apiId
	 * @return
	 */
	IPage<OpenapiTestApi> pageTestApi(Page<OpenapiTestApi> p, String apiId);
}
