package com.bizvane.openapi.business.modules.test.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 接口测试请求参数
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="OpenapiTestApiRequestParams对象", description="接口测试请求参数")
public class OpenapiTestApiRequestParams implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键, 自动生成UUID")
    @TableId(value = "id", type = IdType.UUID)
    private String id;

    @ApiModelProperty(value = "测试接口信息ID")
    private String testApiId;

    @ApiModelProperty(value = "参数名")
    private String name;

    @ApiModelProperty(value = "参数值")
    private String value;

    @ApiModelProperty(value = "商户号")
    private String businessId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;


}
