package com.bizvane.openapi.business.modules.service.service.impl;

import java.util.Date;

import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;
import com.bizvane.openapi.business.modules.service.mapper.OpenapiServiceInfoMapper;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceInfoService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;

/**
 * <p>
 * 服务信息描述 服务实现类
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-05-09
 */
@Service
public class OpenapiServiceInfoServiceImpl extends ServiceImpl<OpenapiServiceInfoMapper, OpenapiServiceInfo> implements OpenapiServiceInfoService {

	@Override
	public boolean save(OpenapiServiceInfo entity) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		Assert.missing(entity.getName(), "Name");
		Assert.missing(entity.getScope(), "Scope");
		Assert.missing(entity.getAlias(), "Alias");
		if(!StringUtils.hasText(entity.getBusinessId())) {
			entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		}
		Assert.hasText(entity.getBusinessId(), Business.BUSINESS_ID_EMPTY);
		
		Date now = new Date();
		entity
		.setCreateTime(now)
		.setModifyTime(now)
		.setId(null);
		return super.save(entity);
	}

	@Override
	public boolean update(OpenapiServiceInfo entity, Wrapper<OpenapiServiceInfo> updateWrapper) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		entity
		.setBusinessId(null)
		.setCreateTime(null)
		.setModifyTime(new Date());
		return super.update(entity, updateWrapper);
	}
}
