package com.bizvane.openapi.business.modules.service.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceApiMapping;
import com.bizvane.openapi.business.modules.service.mapper.OpenapiServiceApiMappingMapper;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceApiMappingService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;

/**
 * <p>
 * 服务接口映射 服务实现类
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-05-09
 */
@Service
public class OpenapiServiceApiMappingServiceImpl extends ServiceImpl<OpenapiServiceApiMappingMapper, OpenapiServiceApiMapping> implements OpenapiServiceApiMappingService {

	@Override
	public boolean save(OpenapiServiceApiMapping entity) {
		if(!StringUtils.hasText(entity.getBusinessId())) {
			entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		}
		Assert.hasText(entity.getBusinessId(), Business.BUSINESS_ID_EMPTY);
		
		return super.save(entity);
	}
}
