package com.bizvane.openapi.business.modules.service.service;

import java.util.List;
import java.util.Set;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiVO;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;
import com.bizvane.openapi.business.modules.service.vo.ServiceApiInfoVO;

/**
 * 
 * @author wang.zeyan
 * 2019年5月9日
 */
public interface OpenapiServiceManager {

	/**
	 * 添加服务信息
	 * @param entity
	 * @return
	 */
	boolean addService(OpenapiServiceInfo entity);
	
	/**
	 * 更新服务信息
	 * @param entity
	 * @param serviceId
	 * @return
	 */
	boolean updateService(OpenapiServiceInfo entity, String serviceId);
	
	/**
	 * 删除服务
	 * @param serviceId
	 * @return
	 */
	boolean deleteService(String serviceId);

	/**
	 * 查询服务信息
	 * @param serviceId
	 * @return
	 */
	OpenapiServiceInfo getService(String serviceId);

	/**
	 * 根据alias 查询服务信息
	 * @param serviceAlias
	 * @return
	 */
	OpenapiServiceInfo getServiceByAlias(String serviceAlias);


	/**
	 * 查询商户下所有服务
	 * @return
	 */
	List<OpenapiServiceInfo> getAllServiceOfBusiness();
	
	/**
	 * 查看所有公开的服务
	 * @param page
	 * @return
	 */
	IPage<OpenapiServiceInfo> pagePublicService(Page<OpenapiServiceInfo> page);



	/**
	 * 添加 服务-接口映射关系
	 * @param serviceId
	 * @param apiIds
	 * @return
	 */
	boolean addServiceApi(String serviceId, Set<String> apiIds);

	/**
	 * 保存 服务-接口映射关系
	 * @param serviceId
	 * @param apiIds
	 * @return
	 */
	boolean saveServiceApi(String serviceId, Set<String> apiIds);

	/**
	 * 
	 * 删除 服务-接口映射关系
	 * @param serviceId
	 * @param apiIds
	 * @return
	 */
	boolean deleteServiceApi(String serviceId, Set<String> apiIds);
	
	/**
	 * 获取服务接口信息
	 * @param serviceId
	 * @return
	 */
	List<OpenapiApiInfo> listServiceApi(String serviceId);
	
	/**
	 * 获取service- api 
	 * @param serviceAlias
	 * @param apiAlias
	 * @return
	 */
	ServiceApiVO getServiceApiDetail(String serviceAlias, String apiAlias);

	/**
	 *
	 * @param serviceId
	 * @return
	 */
	List<ServiceApiInfoVO> getServiceApi(String serviceId);
}
