package com.bizvane.openapi.business.modules.developeraccount.service;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.developeraccount.entity.OpenapiDeveloperAccount;

/**
 * 
 * @author wang.zeyan
 *  2019年5月9日
 */
public interface OpenapiDeveloperAccountManager {

	/**
	 * 申请成为开发者
	 * @return 开发者账号
	 */
	OpenapiDeveloperAccount applyToDeveloper();
	
	/**
	 * 申请成为服务者
	 * @return 服务者账号
	 */
	OpenapiDeveloperAccount applyToProvider();

	/**
	 * 根据Id获取开发者账号信息
	 * @param id
	 * @return
	 */
	OpenapiDeveloperAccount get(String id);
	
	/**
	 * 获取缓存client
	 * @param appKey
	 * @return
	 */
	OpenapiDeveloperAccount getDeveloperAccount(String appKey);

	/**
	 * 根据商户ID获取 服务者账号
	 * @param businessId
	 * @return
	 */
	OpenapiDeveloperAccount getProviderDeveloperAccount(String businessId);
	
	/**
	 * 分页查询当前商户下的开发者账号信息
	 * @param p
	 * @param wrapper
	 * @return
	 */
	IPage<OpenapiDeveloperAccount> pageDeveloperAccount(Page<OpenapiDeveloperAccount> p, QueryWrapper<OpenapiDeveloperAccount> wrapper);
	
	/**
	 * 查询所有开发者/服务者账号
	 * @return
	 */
	List<OpenapiDeveloperAccount> listDeveloperAccount();
}
