package com.bizvane.openapi.business.modules.api.service.impl;

import java.util.Date;

import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.mapper.OpenapiApiInfoMapper;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiInfoService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;
/**
 * <p>
 * 接口信息 服务实现类
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-23
 */
@Service
public class OpenapiApiInfoServiceImpl extends ServiceImpl<OpenapiApiInfoMapper, OpenapiApiInfo> implements OpenapiApiInfoService {

	@Override
	public boolean save(OpenapiApiInfo entity) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		Assert.missing(entity.getName(), "Name");
		Assert.missing(entity.getAlias(), "Alias");
		Assert.missing(entity.getUrl(),"Url");

		if(!StringUtils.hasText(entity.getBusinessId())) {
			entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		}
		Assert.hasText(entity.getBusinessId(), Business.BUSINESS_ID_EMPTY);
		
		Date now = new Date();
		entity
		.setCreateTime(now)
		.setModifyTime(now)
		.setId(null);
		return super.save(entity);
	}

	@Override
	public boolean update(OpenapiApiInfo entity, Wrapper<OpenapiApiInfo> updateWrapper) {
		
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		entity
		.setBusinessId(null)
		.setCreateTime(null)
		.setModifyTime(new Date());
		
		return super.update(entity, updateWrapper);
	}
}
