package com.bizvane.openapi.business.modules.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 接口请求参数
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="OpenapiApiRequestParams对象", description="接口请求参数")
public class OpenapiApiRequestParams implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键,")
    @TableId(value = "id", type = IdType.UUID)
    private String id;

    @ApiModelProperty(value = "接口信息ID")
    private String apiId;

    @ApiModelProperty(value = "请求类型(header, path, query, body[json])")
    private String requestType;

    @ApiModelProperty(value = "参数名称")
    private String name;

    @ApiModelProperty(value = "参数值类型(仅供展示)")
    private String type;

    @ApiModelProperty(value = "商户号")
    private String businessId;

    @ApiModelProperty(value = "版本")
    private Float version;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;


}
