package com.bizvane.openapi.business.consts;

import static com.bizvane.openapi.common.response.CodeMessage.newClientInstance;
import static com.bizvane.openapi.common.response.CodeMessage.newInstance;

import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.response.CodeMessage;

/**
 * 
 * @author wang.zeyan
 *  2019年4月11日
 */
public interface CodeMessageConsts {
	
	/**
	 *  商户管理 
	 * @author wang.zeyan
	 *  2019年4月11日
	 */
	interface Business extends CodeConsts {
		CodeMessage ACCOUNT_EMPTY = newClientInstance("Empty.Account");
		CodeMessage PASSWORD_EMPTY = newClientInstance("Empty.Password");
		CodeMessage INVALID_ACCOUNT = newClientInstance("Invalid.Account");
		CodeMessage WRONG_PASSWORD = newClientInstance("Wrong.Password", "密码错误");
		CodeMessage ENTITY_EMPTY = newClientInstance("Empty.Entity");
		CodeMessage INVALID_BUSINESS = newClientInstance("Invalid.Business");
		CodeMessage BUSINESS_ID_EMPTY = newClientInstance("Empty.BusinessId");
		CodeMessage BUSINESS_NOT_LOGIN = newClientInstance("Business.NotLogin", "商户未登陆");
		CodeMessage DEVELOPER_EXIST = newClientInstance("Exist.Developer", "开发者账号已存在");
		CodeMessage PROVIDER_EXIST = newClientInstance("Exist.Provider", "服务者账号已存在");
		CodeMessage PROVIDER_NOT_EXIST = newClientInstance("NotExist.Provider", "服务者账号不存在");
		CodeMessage INVALID_API_NOTFOUND = newInstance(CodeConsts.NOT_FOUND, "InvalidApi.NotFound", "无效的API,API不存在");
		CodeMessage INVALID_SERVICE_NOTFOUND = newInstance(CodeConsts.NOT_FOUND, "InvalidService.NotFound", "无效的服务,服务不存在");
	}
	
	/**
	 * 接口管理 
	 * @author wang.zeyan
	 *  2019年4月24日
	 */
	interface Api {
		CodeMessage API_ID_EMPTY = newClientInstance("Empty.ApiId");
	}
 	
}
