/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business.modules.test.service.impl;

import brave.Span;
import brave.Tracer;
import brave.propagation.B3SingleFormat;
import brave.propagation.TraceContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.consts.CodeMessageConsts;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiRequestParams;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.developeraccount.entity.OpenapiDeveloperAccount;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountManager;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApi;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApiHistory;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApiRequestParams;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiHistoryService;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiManager;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiRequestParamsService;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.business.utils.WrapperUtils;
import com.bizvane.openapi.common.request.HttpRequest;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.common.utils.SignatureUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OpenapiTestApiManagerImpl
implements OpenapiTestApiManager {
    private static final Logger log = LoggerFactory.getLogger(OpenapiTestApiManagerImpl.class);
    @Autowired
    Tracer tracer;
    @Autowired
    HttpRequest request;
    @Autowired
    OpenapiApiManager apiService;
    @Autowired
    OpenapiTestApiService testApiService;
    @Autowired
    OpenapiTestApiHistoryService apiHistoryService;
    @Autowired
    OpenapiTestApiHistoryService testApiHistoryService;
    @Autowired
    OpenapiTestApiRequestParamsService testApiRequestParamsService;
    @Autowired
    OpenapiDeveloperAccountManager developerAccountManager;
    @Value(value="${spring.application.name}")
    String appName;
    static Set<String> signatureHeaders = Sets.newHashSet((Object[])new String[]{"bizvane-appkey", "bizvane-timestamp", "bizvane-nonce"});
    static String signatureHeadersValue = Joiner.on((char)',').join(signatureHeaders);

    @Override
    public Object executeTest(String apiId, Map<String, Object> params, String businessId) {
        HashMap headersMap;
        HashMap paramsMap;
        HashMap bodyMap;
        OpenapiApiInfo apiInfo;
        block14: {
            Assert.missing((String)apiId, (String[])new String[]{"ApiId"});
            apiInfo = this.apiService.getApiInfo(apiId);
            Assert.notInvalidResource((Object)apiInfo, (String[])new String[]{"ApiInfo"});
            Map<String, OpenapiApiRequestParams> apiRequestParamsMap = this.apiService.getApiRequestParamsMap(apiId);
            bodyMap = Maps.newHashMap();
            paramsMap = Maps.newHashMap();
            headersMap = Maps.newHashMap();
            if (apiRequestParamsMap.isEmpty() || CollectionUtils.isEmpty(params)) break block14;
            for (Map.Entry<String, OpenapiApiRequestParams> entry : apiRequestParamsMap.entrySet()) {
                String key = entry.getKey();
                Object val = params.get(key);
                if (val == null || !StringUtils.hasText((String)val.toString())) continue;
                switch (entry.getValue().getRequestType()) {
                    case "header": {
                        headersMap.put(key, val);
                        break;
                    }
                    case "body": {
                        bodyMap.put(key, val);
                        break;
                    }
                    default: {
                        paramsMap.put(key, val);
                    }
                    case "path": 
                }
            }
        }
        return this.exec(apiInfo, bodyMap, paramsMap, headersMap, apiId, businessId);
    }

    @Override
    public Object executeTest(String testApiId) {
        HashMap headersMap;
        HashMap paramsMap;
        HashMap bodyMap;
        OpenapiApiInfo apiInfo;
        block14: {
            List testParams;
            Assert.missing((String)testApiId, (String[])new String[]{"TestApiId"});
            OpenapiTestApi one = (OpenapiTestApi)this.testApiService.getOne((Wrapper)WrapperUtils.getQueryWrapperId(testApiId, OpenapiTestApi.class));
            Assert.notInvalidResource((Object)one, (String[])new String[]{"TestApi"});
            apiInfo = this.apiService.getApiInfo(one.getApiId());
            Assert.notInvalidResource((Object)apiInfo, (String[])new String[]{"ApiInfo"});
            Map<String, OpenapiApiRequestParams> apiRequestParamsMap = this.apiService.getApiRequestParamsMap(one.getApiId());
            bodyMap = Maps.newHashMap();
            paramsMap = Maps.newHashMap();
            headersMap = Maps.newHashMap();
            if (apiRequestParamsMap.isEmpty() || CollectionUtils.isEmpty((Collection)(testParams = this.testApiRequestParamsService.list((Wrapper)new QueryWrapper().eq((Object)"test_api_id", (Object)testApiId))))) break block14;
            Map<String, OpenapiTestApiRequestParams> testParamsMap = testParams.stream().collect(Collectors.toMap(OpenapiTestApiRequestParams::getName, p -> p));
            for (Map.Entry<String, OpenapiApiRequestParams> entry : apiRequestParamsMap.entrySet()) {
                String key = entry.getKey();
                OpenapiTestApiRequestParams testParam = testParamsMap.get(key);
                if (testParam == null || !StringUtils.hasText((String)testParam.getValue())) continue;
                String val = testParam.getValue();
                switch (entry.getValue().getRequestType()) {
                    case "header": {
                        headersMap.put(key, val);
                        break;
                    }
                    case "body": {
                        bodyMap.put(key, val);
                        break;
                    }
                    default: {
                        paramsMap.put(key, val);
                    }
                    case "path": 
                }
            }
        }
        return this.exec(apiInfo, bodyMap, paramsMap, headersMap, testApiId, null);
    }

    private void secondSignature(Map<String, Object> paramsMap, Map<String, Object> bodyMap, Map<String, Object> headersMap, String providerAppKey, String providerAppSecret, Object requestBusinessId) {
        HashMap signatureHeadersMap = Maps.newHashMap();
        signatureHeadersMap.put("bizvane-nonce", RandomStringUtils.randomAlphabetic((int)8));
        signatureHeadersMap.put("bizvane-timestamp", System.currentTimeMillis());
        signatureHeadersMap.put("bizvane-appkey", providerAppKey);
        HashMap params = Maps.newHashMap();
        params.putAll(paramsMap);
        params.putAll(bodyMap);
        params.putAll(signatureHeadersMap);
        String signatureWithAppSecret = SignatureUtils.sign((String)providerAppSecret, (Map)params);
        signatureHeadersMap.put("bizvane-signature-headers", signatureHeadersValue);
        signatureHeadersMap.put("bizvane-request-business-id", requestBusinessId);
        this.tracer.startScopedSpan(this.appName);
        Span span = this.tracer.currentSpan();
        span.kind(Span.Kind.CLIENT);
        signatureHeadersMap.put("b3", B3SingleFormat.writeB3SingleFormat((TraceContext)span.context()));
        signatureHeadersMap.put("bizvane-request-id", span.context().traceIdString());
        signatureHeadersMap.put("bizvane-signature", signatureWithAppSecret);
        headersMap.putAll(signatureHeadersMap);
    }

    private Object exec(OpenapiApiInfo apiInfo, Map<String, Object> bodyMap, Map<String, Object> paramsMap, Map<String, Object> headersMap, String testApiId, String businessId) {
        JSONObject jSONObject;
        log.info("forward | {} | {} | body:{} | query:{} | headers:{}", new Object[]{apiInfo.getMethod(), apiInfo.getUrl(), JSON.toJSONString(bodyMap), JSON.toJSONString(paramsMap), JSON.toJSONString(headersMap)});
        OpenapiDeveloperAccount providerDeveloperAccount = this.developerAccountManager.getProviderDeveloperAccount(apiInfo.getBusinessId());
        Assert.notNull((Object)providerDeveloperAccount, (CodeMessage)CodeMessageConsts.Business.PROVIDER_NOT_EXIST);
        this.secondSignature(paramsMap, bodyMap, headersMap, providerDeveloperAccount.getAppKey(), providerDeveloperAccount.getAppSecret(), businessId != null ? businessId : apiInfo.getBusinessId());
        Stopwatch stopwatch = Stopwatch.createStarted();
        JSONObject result = null;
        boolean status = true;
        try {
            jSONObject = result = (JSONObject)this.request.request(apiInfo.getMethod().getVal(), apiInfo.getUrl(), bodyMap, paramsMap, headersMap, JSONObject.class);
        }
        catch (Exception e) {
            try {
                result = new JSONObject();
                status = false;
                result.put("error", (Object)e.getMessage());
                result.put("root cause", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                throw e;
            }
            catch (Throwable throwable) {
                stopwatch.stop();
                long us = stopwatch.elapsed(TimeUnit.MICROSECONDS);
                log.info("forward | {} | {} | result:{} | cost: {} \u03bcs | {}", new Object[]{apiInfo.getMethod(), apiInfo.getUrl(), result, us, stopwatch});
                OpenapiTestApiHistory history = new OpenapiTestApiHistory();
                history.setBusinessId(ThreadBusiness.getCurrentBusinessId());
                history.setTestApiId(testApiId);
                history.setTestCost(us);
                history.setTestResult(JSON.toJSONString((Object)result));
                history.setTestStatus(status);
                history.setTestCostFriendly(stopwatch.toString());
                this.testApiHistoryService.save(history);
                throw throwable;
            }
        }
        stopwatch.stop();
        long us = stopwatch.elapsed(TimeUnit.MICROSECONDS);
        log.info("forward | {} | {} | result:{} | cost: {} \u03bcs | {}", new Object[]{apiInfo.getMethod(), apiInfo.getUrl(), result, us, stopwatch});
        OpenapiTestApiHistory history = new OpenapiTestApiHistory();
        history.setBusinessId(ThreadBusiness.getCurrentBusinessId());
        history.setTestApiId(testApiId);
        history.setTestCost(us);
        history.setTestResult(JSON.toJSONString((Object)result));
        history.setTestStatus(status);
        history.setTestCostFriendly(stopwatch.toString());
        this.testApiHistoryService.save(history);
        return jSONObject;
    }

    @Override
    public boolean addTest(OpenapiTestApi entity, String apiId) {
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
        entity.setApiId(apiId);
        return this.testApiService.save(entity);
    }

    @Override
    public boolean updateTest(OpenapiTestApi entity, String id) {
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        return this.testApiService.update(entity, (Wrapper)WrapperUtils.getUpdateWrapperId(id, OpenapiTestApi.class));
    }

    @Override
    public boolean deleteTestApiRequestParamsByApiId(String apiId) {
        Assert.hasText((String)apiId, (CodeMessage)CodeMessageConsts.Api.API_ID_EMPTY);
        return false;
    }

    @Override
    public OpenapiTestApi getTest(String id) {
        return (OpenapiTestApi)this.testApiService.getOne((Wrapper)WrapperUtils.getQueryWrapperId(id, OpenapiTestApi.class));
    }

    @Override
    public boolean addTestApiRequestParams(OpenapiTestApiRequestParams entity, String testApiId) {
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
        entity.setTestApiId(testApiId);
        return this.testApiRequestParamsService.save(entity);
    }

    @Override
    public boolean updateTestApiRequestParams(OpenapiTestApiRequestParams entity, String id) {
        return this.testApiRequestParamsService.update(entity, (Wrapper)WrapperUtils.getUpdateWrapperId(id, OpenapiTestApiRequestParams.class));
    }

    @Override
    public List<OpenapiTestApiRequestParams> getTestApiRequestParams(String testApiId) {
        return this.testApiRequestParamsService.list((Wrapper)new UpdateWrapper().eq((Object)"test_api_id", (Object)testApiId));
    }

    @Override
    public boolean deleteTestApiRequestParams(String id) {
        return this.testApiRequestParamsService.remove((Wrapper)WrapperUtils.getQueryWrapperId(id, OpenapiTestApiRequestParams.class));
    }

    @Override
    public boolean deleteTestApi(String id) {
        return this.testApiService.removeById((Serializable)((Object)id));
    }

    @Override
    public boolean deleteAllTestApi(String apiId) {
        return this.testApiService.remove((Wrapper)WrapperUtils.getQueryWrapperApiId(apiId, OpenapiTestApi.class));
    }

    @Override
    public IPage<OpenapiTestApi> pageTestApi(Page<OpenapiTestApi> p, String apiId) {
        return this.testApiService.page((IPage)p, (Wrapper)WrapperUtils.getQueryWrapperApiId(apiId, OpenapiTestApi.class));
    }
}

