/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business.modules.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.consts.CodeMessageConsts;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiVO;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceApiMapping;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;
import com.bizvane.openapi.business.modules.service.enums.ScopeEnum;
import com.bizvane.openapi.business.modules.service.mapper.OpenapiServiceManagerMapper;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceApiMappingService;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceInfoService;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceManager;
import com.bizvane.openapi.business.modules.service.vo.ServiceApiInfoVO;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpenapiServiceManagerImpl
implements OpenapiServiceManager {
    @Autowired
    OpenapiServiceInfoService serviceInfoService;
    @Autowired
    OpenapiApiManager apiManager;
    @Autowired
    OpenapiServiceApiMappingService serviceApiMappingService;
    @Autowired
    OpenapiServiceManagerMapper mapper;

    @Override
    public boolean addService(OpenapiServiceInfo entity) {
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
        return this.serviceInfoService.save(entity);
    }

    @Override
    public boolean updateService(OpenapiServiceInfo entity, String serviceId) {
        return this.serviceInfoService.update(entity, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)serviceId));
    }

    @Override
    public IPage<OpenapiServiceInfo> pagePublicService(Page<OpenapiServiceInfo> page) {
        return this.serviceInfoService.page((IPage)page, (Wrapper)new QueryWrapper().eq((Object)"scope", (Object)ScopeEnum.PUBLIC));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addServiceApi(String serviceId, Set<String> apiIds) {
        OpenapiServiceInfo serviceInfo = (OpenapiServiceInfo)this.serviceInfoService.getById((Serializable)((Object)serviceId));
        Assert.notNull((Object)serviceInfo, (CodeMessage)CodeMessageConsts.Business.INVALID_SERVICE_NOTFOUND);
        ArrayList mappingList = Lists.newArrayListWithCapacity((int)apiIds.size());
        for (String apiId : apiIds) {
            OpenapiServiceApiMapping o = new OpenapiServiceApiMapping();
            o.setApiId(apiId);
            o.setBusinessId(ThreadBusiness.getCurrentBusinessId());
            o.setCreateTime(new Date());
            o.setServiceId(serviceId);
            mappingList.add(o);
        }
        return this.serviceApiMappingService.saveBatch(mappingList);
    }

    @Override
    public boolean deleteService(String serviceId) {
        int count = this.serviceApiMappingService.count((Wrapper)new QueryWrapper().eq((Object)"service_id", (Object)serviceId));
        Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)String.format("\u8be5\u670d\u52a1\u4e0b\u7ed1\u5b9a\u4e86%s\u4e2a\u63a5\u53e3,\u8bf7\u5148\u5220\u9664\u5173\u8054\u5173\u7cfb", count));
        return this.serviceInfoService.removeById((Serializable)((Object)serviceId));
    }

    @Override
    public OpenapiServiceInfo getService(String serviceId) {
        return (OpenapiServiceInfo)this.serviceInfoService.getById((Serializable)((Object)serviceId));
    }

    @Override
    public OpenapiServiceInfo getServiceByAlias(String serviceAlias) {
        Assert.missing((String)serviceAlias, (String[])new String[]{"serviceAlias"});
        QueryWrapper queryWrapper = new QueryWrapper();
        OpenapiServiceInfo entity = new OpenapiServiceInfo();
        entity.setAlias(serviceAlias);
        queryWrapper.setEntity((Object)entity);
        return (OpenapiServiceInfo)this.serviceInfoService.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<OpenapiServiceInfo> getAllServiceOfBusiness() {
        return this.serviceInfoService.list();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveServiceApi(String serviceId, Set<String> apiIds) {
        OpenapiServiceInfo serviceInfo = (OpenapiServiceInfo)this.serviceInfoService.getById((Serializable)((Object)serviceId));
        Assert.notNull((Object)serviceInfo, (CodeMessage)CodeMessageConsts.Business.INVALID_SERVICE_NOTFOUND);
        List list = this.serviceApiMappingService.list((Wrapper)new QueryWrapper().eq((Object)"service_id", (Object)serviceId));
        Collection srcApiIds = Collections2.transform((Collection)list, (Function)new Function<OpenapiServiceApiMapping, String>(){

            public @Nullable String apply(@Nullable OpenapiServiceApiMapping input) {
                return input.getApiId();
            }
        });
        HashSet set3 = Sets.newHashSet();
        set3.clear();
        set3.addAll(srcApiIds);
        set3.removeAll(apiIds);
        if (set3.size() > 0) {
            this.deleteServiceApi(serviceId, set3);
        }
        set3.clear();
        set3.addAll(apiIds);
        set3.removeAll(srcApiIds);
        ArrayList mappingList = Lists.newArrayListWithCapacity((int)set3.size());
        for (String apiId : set3) {
            OpenapiServiceApiMapping o = new OpenapiServiceApiMapping();
            o.setApiId(apiId);
            o.setBusinessId(ThreadBusiness.getCurrentBusinessId());
            o.setCreateTime(new Date());
            o.setServiceId(serviceId);
            mappingList.add(o);
        }
        return this.serviceApiMappingService.saveBatch(mappingList);
    }

    @Override
    public boolean deleteServiceApi(String serviceId, Set<String> apiIds) {
        return this.serviceApiMappingService.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"service_id", (Object)serviceId)).in((Object)"api_id", apiIds));
    }

    @Override
    public List<OpenapiApiInfo> listServiceApi(String serviceId) {
        OpenapiServiceInfo serviceInfo = (OpenapiServiceInfo)this.serviceInfoService.getById((Serializable)((Object)serviceId));
        Assert.notNull((Object)serviceInfo, (CodeMessage)CodeMessageConsts.Business.INVALID_SERVICE_NOTFOUND);
        List list = this.serviceApiMappingService.list((Wrapper)new QueryWrapper().eq((Object)"service_id", (Object)serviceId));
        List<Object> resultList = Lists.newArrayList();
        if (!list.isEmpty()) {
            Collection apiIds = Collections2.transform((Collection)list, (Function)new Function<OpenapiServiceApiMapping, String>(){

                public @Nullable String apply(@Nullable OpenapiServiceApiMapping input) {
                    return input.getApiId();
                }
            });
            resultList = this.apiManager.listApiInfo(apiIds);
        }
        return resultList;
    }

    @Override
    public ServiceApiVO getServiceApiDetail(String serviceAlias, String apiAlias) {
        return this.mapper.getServiceApiAndParams(serviceAlias, apiAlias);
    }

    @Override
    public List<ServiceApiInfoVO> getServiceApi(String serviceId) {
        return this.mapper.getServiceApiInfo(serviceId);
    }
}

