/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business.modules.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.openapi.business.consts.CodeMessageConsts;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiResponseParams;
import com.bizvane.openapi.business.modules.api.mapper.OpenapiApiResponseParamsMapper;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiResponseParamsService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OpenapiApiResponseParamsServiceImpl
extends ServiceImpl<OpenapiApiResponseParamsMapper, OpenapiApiResponseParams>
implements OpenapiApiResponseParamsService {
    @Autowired
    OpenapiApiManager apiService;

    public boolean save(OpenapiApiResponseParams entity) {
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        Assert.missing((String)entity.getName(), (String[])new String[]{"Name"});
        Assert.missing((String)entity.getApiId(), (String[])new String[]{"ApiId"});
        Assert.missing((String)entity.getType(), (String[])new String[]{"Type"});
        if (!StringUtils.hasText((String)entity.getBusinessId())) {
            entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
        }
        Assert.hasText((String)entity.getBusinessId(), (CodeMessage)CodeMessageConsts.Business.BUSINESS_ID_EMPTY);
        OpenapiApiInfo apiInfo = this.apiService.getApiInfo(entity.getApiId());
        Assert.notInvalidResource((Object)apiInfo, (String[])new String[]{"ApiInfo"});
        Date now = new Date();
        entity.setCreateTime(now).setModifyTime(now).setId(null);
        return super.save((Object)entity);
    }

    public boolean update(OpenapiApiResponseParams entity, Wrapper<OpenapiApiResponseParams> updateWrapper) {
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        entity.setBusinessId(null).setApiId(null).setCreateTime(null).setModifyTime(new Date());
        return super.update((Object)entity, updateWrapper);
    }
}

