/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business.modules.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.consts.CodeMessageConsts;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiRequestParams;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiResponseParams;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiInfoService;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiRequestParamsService;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiResponseParamsService;
import com.bizvane.openapi.business.modules.api.vo.ApiInfoVO;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.consts.CodeConsts;
import com.bizvane.openapi.common.consts.CodeMessageConsts;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OpenapiApiManagerImpl
implements OpenapiApiManager {
    @Autowired
    OpenapiApiInfoService apiInfoService;
    @Autowired
    OpenapiApiRequestParamsService apiRequestParamsService;
    @Autowired
    OpenapiApiResponseParamsService apiResponseParamsService;

    @Override
    public IPage<OpenapiApiInfo> pageApiInfo(Page<OpenapiApiInfo> page, QueryWrapper<OpenapiApiInfo> wrapper) {
        return this.apiInfoService.page((IPage)page, (Wrapper)wrapper);
    }

    @Override
    public boolean addApiInfo(OpenapiApiInfo entity) {
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
        Assert.missing((String)entity.getAlias(), (String[])new String[]{"Alias"});
        OpenapiApiInfo one = (OpenapiApiInfo)this.apiInfoService.getOne((Wrapper)new QueryWrapper().eq((Object)"alias", (Object)entity.getAlias()));
        Assert.isNull((Object)one, (CodeMessage)CodeMessage.newInstance((CodeMessage)CodeConsts.DUPLICATE_PARAMETER_NAME, (String[])new String[]{"Alias"}));
        return this.apiInfoService.save(entity);
    }

    @Override
    public boolean addApiResponseParams(OpenapiApiResponseParams entity, String apiId) {
        this.checkApiIdAndBusinessIdRelationship(apiId, ThreadBusiness.getCurrentBusinessId());
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        entity.setApiId(apiId);
        entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
        return this.apiResponseParamsService.save(entity);
    }

    @Override
    public boolean addApiRequestParams(OpenapiApiRequestParams entity, String apiId) {
        this.checkApiIdAndBusinessIdRelationship(apiId, ThreadBusiness.getCurrentBusinessId());
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        entity.setApiId(apiId);
        entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
        return this.apiRequestParamsService.save(entity);
    }

    @Override
    public boolean updateApiInfo(OpenapiApiInfo entity, String id) {
        this.checkId(id);
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        return this.apiInfoService.update(entity, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)id));
    }

    @Override
    public boolean updateApiRequestParams(OpenapiApiRequestParams entity, String id) {
        this.checkId(id);
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        OpenapiApiRequestParams one = (OpenapiApiRequestParams)this.apiRequestParamsService.getById((Serializable)((Object)id));
        Assert.notNull((Object)one, (CodeMessage)CodeConsts.INVALID_RESOURCE_NOT_FOUND);
        return this.getProxy().updateApiRequestParams(entity, one);
    }

    public boolean updateApiRequestParams(OpenapiApiRequestParams update, OpenapiApiRequestParams source) {
        return this.apiRequestParamsService.update(update, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)source.getId()));
    }

    @Override
    public boolean deleteApiRequestParams(String id) {
        this.checkId(id);
        OpenapiApiRequestParams one = (OpenapiApiRequestParams)this.apiRequestParamsService.getById((Serializable)((Object)id));
        Assert.notNull((Object)one, (CodeMessage)CodeConsts.INVALID_RESOURCE_NOT_FOUND);
        return this.getProxy().deleteApiRequestParams(one);
    }

    public boolean deleteApiRequestParams(OpenapiApiRequestParams source) {
        return this.apiRequestParamsService.removeById((Serializable)((Object)source.getId()));
    }

    @Override
    public boolean updateApiResponseParams(OpenapiApiResponseParams entity, String id) {
        this.checkId(id);
        Assert.notNull((Object)entity, (CodeMessage)CodeMessageConsts.Business.ENTITY_EMPTY);
        return this.apiResponseParamsService.update(entity, (Wrapper)new UpdateWrapper().eq((Object)"id", (Object)id));
    }

    @Override
    public OpenapiApiInfo getApiInfo(String id) {
        this.checkId(id);
        return (OpenapiApiInfo)this.apiInfoService.getById((Serializable)((Object)id));
    }

    @Override
    public List<OpenapiApiRequestParams> getApiRequestParams(String apiId) {
        this.checkId(apiId);
        return this.apiRequestParamsService.list((Wrapper)new QueryWrapper().eq((Object)"api_id", (Object)apiId));
    }

    @Override
    public Map<String, OpenapiApiRequestParams> getApiRequestParamsMap(String apiId) {
        Map<Object, Object> map = Maps.newHashMap();
        List<OpenapiApiRequestParams> paramsList = this.getApiRequestParams(apiId);
        if (!CollectionUtils.isEmpty(paramsList)) {
            map = paramsList.stream().collect(Collectors.toMap(OpenapiApiRequestParams::getName, p -> p));
        }
        return map;
    }

    @Override
    public List<OpenapiApiResponseParams> getApiResponseParams(String apiId) {
        this.checkId(apiId);
        return this.apiResponseParamsService.list((Wrapper)new QueryWrapper().eq((Object)"api_id", (Object)apiId));
    }

    @Override
    public ApiInfoVO getApiInfoDetail(String apiId) {
        this.checkId(apiId);
        ApiInfoVO vo = new ApiInfoVO();
        vo.setApiInfo(this.getApiInfo(apiId));
        vo.setApiRequestParams(this.getApiRequestParams(apiId));
        vo.setApiResponseParams(this.getApiResponseParams(apiId));
        return vo;
    }

    @Override
    public boolean deleteApiInfo(String id) {
        this.checkId(id);
        int count = this.apiRequestParamsService.count((Wrapper)new QueryWrapper().eq((Object)"api_id", (Object)id));
        Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)String.format("\u8be5\u63a5\u53e3\u4e0b\u8fd8\u6709%s\u4e2a\u8bf7\u6c42\u53c2\u6570\u4fe1\u606f,\u4e0d\u80fd\u5220\u9664", count));
        count = this.apiResponseParamsService.count((Wrapper)new QueryWrapper().eq((Object)"api_id", (Object)id));
        Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)String.format("\u8be5\u63a5\u53e3\u4e0b\u8fd8\u6709%s\u4e2a\u8fd4\u56de\u53c2\u6570\u4fe1\u606f,\u4e0d\u80fd\u5220\u9664", count));
        return this.apiInfoService.remove((Wrapper)new QueryWrapper().eq((Object)"id", (Object)id));
    }

    @Override
    public boolean deleteApiResponseParams(String id) {
        this.checkId(id);
        return this.apiResponseParamsService.remove((Wrapper)new QueryWrapper().eq((Object)"id", (Object)id));
    }

    @Override
    public List<OpenapiApiInfo> listApiInfo(Collection<String> apiIds) {
        return this.apiInfoService.list((Wrapper)new QueryWrapper().in((Object)"id", apiIds));
    }

    private void checkApiIdAndBusinessIdRelationship(String apiId, String businessId) {
        Assert.hasText((String)apiId, (CodeMessage)CodeMessageConsts.Api.API_ID_EMPTY);
        OpenapiApiInfo apiInfo = (OpenapiApiInfo)this.apiInfoService.getById((Serializable)((Object)apiId));
        Assert.notNull((Object)apiInfo, (CodeMessage)CodeConsts.INVALID_RESOURCE_NOT_FOUND);
        Assert.isTrue((boolean)businessId.equals(apiInfo.getBusinessId()), (CodeMessage)CodeConsts.RESOURCE_PERMISSION_DENIED);
    }

    private void checkId(String id) {
        Assert.notNull((Object)id, (CodeMessage)CodeMessageConsts.Base.ID_EMPTY);
    }

    private OpenapiApiManagerImpl getProxy() {
        if (AopUtils.isAopProxy((Object)this)) {
            return (OpenapiApiManagerImpl)AopContext.currentProxy();
        }
        return this;
    }

    @Override
    public List<OpenapiApiInfo> listAll() {
        return this.apiInfoService.list();
    }
}

