package com.bizvane.openapi.business.modules.test.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 接口测试记录
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="OpenapiTestApiHistory对象", description="接口测试记录")
public class OpenapiTestApiHistory implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键, 自动生成UUID")
    @TableId(value = "id", type = IdType.UUID)
    private String id;

    @ApiModelProperty(value = "测试接口信息ID")
    private String testApiId;

    @ApiModelProperty(value = "服务测试ID(非服务测试为空)")
    private String serviceTestId;

    @ApiModelProperty(value = "测试结果")
    private String testResult;
    
    @ApiModelProperty(value = "测试结果状态 成功 || 失败")
    private boolean testStatus;

    @ApiModelProperty(value = "测试耗时(微秒)")
    private Long testCost;
    
    @ApiModelProperty(value = "测试耗时(友好显示)")
    private String testCostFriendly;

    @ApiModelProperty(value = "商户号")
    private String businessId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;


}
