package com.bizvane.openapi.business.modules.service.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bizvane.openapi.business.modules.service.enums.ScopeEnum;

import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 服务信息描述
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="OpenapiServiceInfo对象", description="服务信息描述")
public class OpenapiServiceInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键, 自动生成UUID")
    @TableId(value = "id", type = IdType.UUID)
    private String id;

    @ApiModelProperty(value = "服务名称")
    private String name;
    
    @ApiModelProperty(value = "别名(唯一)")
    private String alias;

    @ApiModelProperty(value = "商户号")
    private String businessId;

    @ApiModelProperty(value = "状态(0新建, 1上线, 2下线)")
    private Integer status;
    
    @ApiModelProperty(value = "作用域(public公开, private私有,pay付费)")
    private ScopeEnum scope;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;


}
