package com.bizvane.openapi.business.modules.developeraccount.service.impl;

import java.util.Date;

import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.modules.developeraccount.entity.OpenapiDeveloperAccount;
import com.bizvane.openapi.business.modules.developeraccount.mapper.OpenapiDeveloperAccountMapper;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;
/**
 * <p>
 * 开发者/服务者账号 服务实现类
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-23
 */
@Service
public class OpenapiDeveloperAccountServiceImpl extends ServiceImpl<OpenapiDeveloperAccountMapper, OpenapiDeveloperAccount> implements OpenapiDeveloperAccountService {

	@Override
	public boolean save(OpenapiDeveloperAccount entity) {
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		if(!StringUtils.hasText(entity.getBusinessId())) {
			entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		}
		Assert.hasText(entity.getBusinessId(), Business.BUSINESS_ID_EMPTY);
		
		Date now = new Date();
		entity.setCreateTime(now);
		entity.setModifyTime(now);
		entity.setStatus(0);
		entity.setId(null);
		return super.save(entity);
	}
}
