package com.bizvane.openapi.business.modules.api.service.impl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiResponseParams;
import com.bizvane.openapi.business.modules.api.mapper.OpenapiApiResponseParamsMapper;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiResponseParamsService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.common.utils.Assert;

/**
 * <p>
 * 接口返回参数 服务实现类
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-23
 */
@Service
public class OpenapiApiResponseParamsServiceImpl extends ServiceImpl<OpenapiApiResponseParamsMapper, OpenapiApiResponseParams> implements OpenapiApiResponseParamsService {

	@Autowired
	OpenapiApiManager apiService;
	
	@Override
	public boolean save(OpenapiApiResponseParams entity) {
		
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		Assert.missing(entity.getName(), "Name");
		Assert.missing(entity.getApiId(), "ApiId");
		Assert.missing(entity.getType(), "Type");
		
		if(!StringUtils.hasText(entity.getBusinessId())) {
			entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		}
		Assert.hasText(entity.getBusinessId(), Business.BUSINESS_ID_EMPTY);
		
		OpenapiApiInfo apiInfo = apiService.getApiInfo(entity.getApiId());
		Assert.notInvalidResource(apiInfo, "ApiInfo");
		
		Date now = new Date();
		entity
		.setCreateTime(now)
		.setModifyTime(now)
		.setId(null);
		return super.save(entity);
	}

	@Override
	public boolean update(OpenapiApiResponseParams entity, Wrapper<OpenapiApiResponseParams> updateWrapper) {
		
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		entity
		.setBusinessId(null)
		.setApiId(null)
		.setCreateTime(null)
		.setModifyTime(new Date());
		
		return super.update(entity, updateWrapper);
	}
	
	
}
