package com.bizvane.openapi.business.modules.api.service.impl;

import com.bizvane.openapi.business.consts.CodeMessageConsts.Business;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiRequestParams;
import com.bizvane.openapi.business.modules.api.mapper.OpenapiApiRequestParamsMapper;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiInfoService;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiRequestParamsService;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * <p>
 * 接口请求参数 服务实现类
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-23
 */
@Service
public class OpenapiApiRequestParamsServiceImpl extends ServiceImpl<OpenapiApiRequestParamsMapper, OpenapiApiRequestParams> implements OpenapiApiRequestParamsService {

	@Autowired
	OpenapiApiInfoService apiInfoService;
	
	@Override
	public boolean save(OpenapiApiRequestParams entity) {
		
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		Assert.missing(entity.getName(), "Name");
		Assert.missing(entity.getApiId(), "ApiId");
		Assert.missing(entity.getRequestType(), "RequestType");
		Assert.missing(entity.getType(), "Type");
		
		if(!StringUtils.hasText(entity.getBusinessId())) {
			entity.setBusinessId(ThreadBusiness.getCurrentBusinessId());
		}
		Assert.hasText(entity.getBusinessId(), Business.BUSINESS_ID_EMPTY);
		
		OpenapiApiInfo apiInfo = apiInfoService.getById(entity.getApiId());
		Assert.notInvalidResource(apiInfo, "ApiInfo");
		
		Date now = new Date();
		entity.setCreateTime(now);
		entity.setModifyTime(now);
		entity.setId(null);
		return super.save(entity);
	}

	@Override
	public boolean update(OpenapiApiRequestParams entity, Wrapper<OpenapiApiRequestParams> updateWrapper) {
		
		Assert.notNull(entity, Business.ENTITY_EMPTY);
		entity
		.setBusinessId(null)
		.setApiId(null)
		.setCreateTime(null)
		.setModifyTime(new Date());
		
		return super.update(entity, updateWrapper);
	}
	
	

	/*public boolean addApiRequestParamsBatch(Collection<OpenapiApiRequestParams> paramsList, String apiId, String businessId) {
		Assert.notEmpty(paramsList, "参数列表不能为空!");
		Assert.hasText(apiId, "apiId不能为空!");
		Assert.hasText(businessId, "businessId不能为空!");
		
		Date now = new Date();
		for (OpenapiApiRequestParams entity : paramsList) {
			Assert.hasText(entity.getName(), "参数名称不能为空!");
			Assert.hasText(entity.getRequestType(), String.format("参数%s 请求类型不能为空!", entity.getName()));
			Assert.hasText(entity.getType(), String.format("参数%s 参数值类型不能为空!", entity.getName()));
			entity.setCreateTime(now);
			entity.setModifyTime(now);
			entity.setId(null);
		}
		return this.saveBatch(paramsList, 50);
	}*/
}
