package com.bizvane.openapi.business.modules.api.entity;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bizvane.openapi.business.modules.api.enums.MethodEnum;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 接口信息
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="OpenapiApiInfo对象", description="接口信息")
public class OpenapiApiInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.UUID)
    private String id;

    @ApiModelProperty(value = "接口名称")
    private String name;

    @ApiModelProperty(value = "接口别名([a-zA-Z])")
    private String alias;

    @ApiModelProperty(value = "请求地址")
    private String url;

    @ApiModelProperty(value = "请求方式(get,post,put,delete)")
    private MethodEnum method;

    @ApiModelProperty(value = "商户号")
    private String businessId;

    @ApiModelProperty(value = "版本")
    private Float version;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;


}
