/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.config.MybatisPlusConfig;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.api.vo.ApiInfoVO;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceManager;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import springfox.documentation.OperationNameGenerator;
import springfox.documentation.builders.OperationBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingScannerPlugin;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spring.web.readers.operation.CachingOperationNameGenerator;

@Component
@Order(value=-2147482648)
public class ServiceApiListingScanner
implements ApiListingScannerPlugin,
ApplicationEventPublisherAware {
    private static final Logger log = LoggerFactory.getLogger(ServiceApiListingScanner.class);
    @Autowired
    OpenapiServiceManager openapiServiceManager;
    @Autowired
    OpenapiApiManager openapiApiManager;
    @Autowired
    TypeResolver typeResolver;
    public static Set<String> classNameSet = Sets.newHashSet();
    private ApplicationEventPublisher publisher;

    public List<ApiDescription> apply(DocumentationContext context) {
        if (!"dynamicapi".equals(context.getGroupName())) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        try {
            MybatisPlusConfig.tableFilter = true;
            this.openapiServiceManager.pagePublicService(new Page(1L, 1000L).setSearchCount(false)).getRecords().forEach(service -> this.openapiServiceManager.listServiceApi(service.getId()).forEach(api -> {
                ApiInfoVO apiInfoDetail = this.openapiApiManager.getApiInfoDetail(api.getId());
                ArrayList paramsList = Lists.newArrayList();
                if (apiInfoDetail.getApiRequestParams() != null) {
                    ArrayList itemModel = Lists.newArrayList();
                    apiInfoDetail.getApiRequestParams().forEach(rp -> {
                        Parameter headerParameter = new ParameterBuilder().type(new TypeResolver().resolve(String.class, new Type[0])).name("bizvane-request-business-id").description("CRM\u4f01\u4e1aID").modelRef((ModelReference)new ModelRef("string")).parameterType("header").parameterAccess("access").required(true).defaultValue("").build();
                        paramsList.add(headerParameter);
                        if (!"body".equalsIgnoreCase(rp.getRequestType())) {
                            Parameter parameter = new ParameterBuilder().type(new TypeResolver().resolve(String.class, new Type[0])).name(rp.getName()).modelRef((ModelReference)new ModelRef("string")).parameterType(rp.getRequestType()).parameterAccess("access").defaultValue("").build();
                            paramsList.add(parameter);
                        } else {
                            itemModel.add(rp.getName());
                        }
                    });
                    if (itemModel.size() > 0) {
                        String className = service.getAlias() + api.getAlias();
                        className = className.replaceAll("\\-", "");
                        ResolvedType resolve = null;
                        if (!classNameSet.contains(className)) {
                            resolve = this.typeResolver.resolve((Type)this.createRefModel(className, (List)itemModel), new Type[0]);
                            context.getAdditionalModels().add(resolve);
                            classNameSet.add(className);
                        } else {
                            try {
                                resolve = this.typeResolver.resolve(Class.forName("com.bizvane.openapi.business.modelref." + className), new Type[0]);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                        Parameter parameter = new ParameterBuilder().type(resolve).name("entity").modelRef((ModelReference)new ModelRef(className)).parameterType("body").required(true).parameterAccess("access").build();
                        paramsList.add(parameter);
                    }
                }
                ApiDescription apiDescription = new ApiDescription("dynamicapi", String.format("/business/manager/test/api/%s/%s/exec", api.getId(), service.getAlias()), null, (List)Lists.newArrayList((Object[])new Operation[]{new OperationBuilder((OperationNameGenerator)new CachingOperationNameGenerator()).method(HttpMethod.POST).consumes((Set)Sets.newHashSet((Object[])new String[]{"application/json"})).produces((Set)Sets.newHashSet((Object[])new String[]{"application/json;charset=UTF-8"})).summary(api.getName()).responseMessages((Set)Sets.newHashSet((Object[])new ResponseMessage[]{new ResponseMessageBuilder().code(200).message("OK").responseModel((ModelReference)new ModelRef("map")).build()})).uniqueId(service.getAlias() + api.getAlias()).responseModel((ModelReference)new ModelRef("map")).tags((Set)Sets.newHashSet((Object[])new String[]{service.getName()})).parameters((List)paramsList).build()}), Boolean.valueOf(true));
                list.add(apiDescription);
            }));
        }
        finally {
            MybatisPlusConfig.tableFilter = false;
        }
        return list;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    private Class createRefModel(String alias, List<String> propertys) {
        ClassPool pool = ClassPool.getDefault();
        CtClass ctClass = pool.makeClass("com.bizvane.openapi.business.modelref." + alias);
        try {
            for (int i = 0; i < propertys.size(); ++i) {
                ctClass.addField(this.createField(propertys.get(i), ctClass));
            }
            ConstPool constPool = ctClass.getClassFile().getConstPool();
            AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation("io.swagger.annotations.ApiModel", constPool);
            attr.addAnnotation(annotation);
            ctClass.getClassFile().addAttribute((AttributeInfo)attr);
            ctClass.addInterface(pool.makeInterface("java.io.Serializable"));
            return ctClass.toClass();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private CtField createField(String property, CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtField ctField = new CtField(ClassPool.getDefault().get(String.class.getName()), property, ctClass);
        ctField.setModifiers(1);
        ConstPool constPool = ctClass.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation("io.swagger.annotations.ApiModelProperty", constPool);
        attr.addAnnotation(annotation);
        ctField.getFieldInfo().addAttribute((AttributeInfo)attr);
        return ctField;
    }
}

