package com.bizvane.openapi.business.utils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.bizvane.openapi.business.consts.StringConsts;

/**
 * 
 * @author wang.zeyan
 *  2019年5月5日
 */
public class WrapperUtils {

	public static <T> QueryWrapper<T> getQueryWrapperId(String id, Class<T> clazz){
		return new QueryWrapper<T>().eq(StringConsts.ID, id);
	}
	
	public static <T> QueryWrapper<T> getQueryWrapperApiId(String apiId, Class<T> clazz){
		return new QueryWrapper<T>().eq(StringConsts.API_ID, apiId);
	}
	
	public static <T> UpdateWrapper<T> getUpdateWrapperId(String id, Class<T> clazz){
		return new UpdateWrapper<T>().eq(StringConsts.ID, id);
	}
	
	public static <T> UpdateWrapper<T> getUpdateWrapperApiId(String apiId, Class<T> clazz){
		return new UpdateWrapper<T>().eq(StringConsts.API_ID, apiId);
	}
	
}
