package com.bizvane.openapi.business.utils;


import com.bizvane.openapi.business.modules.business.entity.OpenapiBusinessMain;

/**
 * 
 * @author wang.zeyan
 *  2019年4月23日
 */
public class ThreadBusiness {

	/**
	 * 记录当前线程商户信息
	 */
	private static ThreadLocal<OpenapiBusinessMain> currentBusiness = new ThreadLocal<OpenapiBusinessMain>();
	
	public static ThreadLocal<OpenapiBusinessMain> getCurrentBusiness() {
		
		return currentBusiness;
	}
	
	/**
	 * 获取当前线程商户信息
	 * @return
	 */
	public static OpenapiBusinessMain getCurrentBusinessInfo() {
		
		return currentBusiness.get();
	}
	
	/**
	 * 移除当前线程变量
	 */
	public static void remove() {
		currentBusiness.remove();
	}
	
	/**
	 * <p>
	 * 获取当前线程商户号/商户ID
	 * </p>
	 * @return
	 */
	public static String getCurrentBusinessId() {
		OpenapiBusinessMain bm = getCurrentBusinessInfo();
		return bm == null ? null : bm.getId();
	}
	
	/**
	 * 获取当前商户 account
	 * @return
	 */
	public static String getCurrentBusinessAccount() {
		OpenapiBusinessMain bm = getCurrentBusinessInfo();
		return bm == null ? null : bm.getAccount();
	}
	
}
