package com.bizvane.openapi.business.modules.test.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApi;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApiRequestParams;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiManager;
import com.bizvane.openapi.common.response.Response;
import com.bizvane.openapi.common.response.ResponseProxy;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import springfox.documentation.annotations.ApiIgnore;

/**
 * 
 * @author wang.zeyan
 *  2019年4月24日
 */
@Api(tags = "测试接口管理")
@RestController
@RequestMapping("/business/manager/test/api")
@ApiIgnore
public class OpenapiTestApiController {

	@Autowired
	OpenapiTestApiManager testApiManager;
	
	@ApiOperation("执行测试")
	@PostMapping("/exec/{testApiId}")
	public Response exec(@PathVariable String testApiId) {
		
		return Response.ok(testApiManager.executeTest(testApiId));
	}
	
	@ApiOperation("修改测试接口信息")
	@PutMapping("/{id}")
	public Object addTestApiInfo(@PathVariable String id, @RequestBody OpenapiTestApi entity) {

		return ResponseProxy.r(testApiManager.updateTest(entity, id)); 
	}
	
	@ApiOperation("获取测试接口信息")
	@GetMapping("/{id}")
	public Object apiInfo(@PathVariable String id) {

		return Response.ok(testApiManager.getTest(id)); 
	}
	
	@ApiOperation("删除测试接口信息")
	@DeleteMapping("/{id}")
	public Object deleteApiInfo(@PathVariable String id) {

		return ResponseProxy.r(testApiManager.deleteTestApi(id));
	}
	
	@ApiOperation("添加测试接口请求参数信息")
	@PostMapping("/params/{testApiId}")
    public Object addTestApiRequestParams(@PathVariable String testApiId, @RequestBody OpenapiTestApiRequestParams entity){

		return ResponseProxy.r(testApiManager.addTestApiRequestParams(entity, testApiId), entity.getId());
    }
	
	@ApiOperation("修改测试接口请求参数信息")
	@PutMapping("/params/{id}")
    public Object updateTestApiRequestParams(@PathVariable String id, @RequestBody OpenapiTestApiRequestParams entity){
        
		return ResponseProxy.r(testApiManager.updateTestApiRequestParams(entity, id));
    }
	
	@ApiOperation("接口请求参数信息列表")
	@GetMapping("/params/{testApiId}")
	public Object getApiRequestParams(@PathVariable String testApiId) {

		return Response.ok(testApiManager.getTestApiRequestParams(testApiId)); 
	}
	
	@ApiOperation("删除测试接口请求参数信息")
	@DeleteMapping("/params/{id}")
    public Object deleteTestApiRequestParams(@PathVariable String id){
        
		return ResponseProxy.r(testApiManager.deleteTestApiRequestParams(id));
    }
}
