package com.bizvane.openapi.business.modules.service.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicResponseParameters;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceManager;
import com.bizvane.openapi.common.response.ResponseProxy;

import java.util.List;

/**
 * @author wang.zeyan
 * 2019年5月10日
 */
@Api(tags = "服务管理")
@RestController
@RequestMapping("/business/manager/service")
public class OpenapiServiceController {

    @Autowired
    OpenapiServiceManager serviceManager;

    @ApiOperation("创建服务")
    @ApiOperationSupport(
            ignoreParameters = {"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.status"},
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "id"))
    )
    @PostMapping
    public Object addService(@RequestBody OpenapiServiceInfo entity) {

        return ResponseProxy.r(serviceManager.addService(entity), entity.getId());
    }

    @ApiOperation("修改服务")
    @ApiOperationSupport(
            ignoreParameters = {"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.status"},
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @PutMapping("/{id}")
    public boolean updateService(@PathVariable String id, @RequestBody OpenapiServiceInfo entity) {

        return serviceManager.updateService(entity, id);
    }

    @ApiOperation("删除服务")
    @ApiOperationSupport(
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @DeleteMapping("/{id}")
    public boolean deleteService(@PathVariable String id) {

        return serviceManager.deleteService(id);
    }

	/*@ApiOperation("查询服务基本信息")
	@GetMapping("/{id}")
	public Object getService(@PathVariable String id) {

		return serviceManager.getService(id);
	}*/

    @ApiOperation("查询所有服务")
    @GetMapping("/all")
    public List<OpenapiServiceInfo> getAllService() {

        return serviceManager.getAllServiceOfBusiness();
    }
}
