package com.bizvane.openapi.business.modules.login;

import javax.servlet.http.HttpSession;

import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import com.bizvane.openapi.business.modules.business.entity.OpenapiBusinessMain;
import com.bizvane.openapi.business.modules.business.service.OpenapiBusinessMainService;
import com.bizvane.openapi.common.response.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
 * 商户登陆
 * @author wang.zeyan
 *  2019年4月22日
 */
@RestController
@RequestMapping("/business")
@Api(tags = "登录")
public class LoginController {

	@Autowired
	HttpSession session;
	
	@Autowired
	OpenapiBusinessMainService service;
	
	@ApiOperation("登录")
	@PostMapping(value = "/login")
	public void login(@RequestBody LoginVO vo){
		OpenapiBusinessMain result = service.login(vo.getAccount(), vo.getPassword());
		session.setAttribute("business", result);
	}
	
	@ApiOperation("登出")
	@GetMapping("/logout")
	public void logout() {
		session.invalidate();
	}
}
