package com.bizvane.openapi.business.modules.api.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiRequestParams;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiResponseParams;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.api.vo.ApiInfoVO;
import com.bizvane.openapi.common.response.ResponseProxy;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicResponseParameters;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author wang.zeyan
 * 2019年4月24日
 */
@Api(tags = "接口管理")
@RestController
@RequestMapping("/business/manager/api")
public class OpenapiApiController {

    @Autowired
    OpenapiApiManager apiManager;


    @ApiOperation(value = "接口列表")
    @GetMapping("/list")
    public IPage<OpenapiApiInfo> list(
            @RequestParam(defaultValue = "1") Long page,
            @RequestParam(defaultValue = "10") Long size,
            String[] ascs,
            String[] descs,
            OpenapiApiInfo condition) {
        Page<OpenapiApiInfo> p = new Page<>(page, size);
        if (ArrayUtils.isNotEmpty(ascs)) {
            p.setAsc(ascs);
        }
        if (ArrayUtils.isNotEmpty(descs)) {
            p.setDesc(descs);
        }

        QueryWrapper<OpenapiApiInfo> wrapper = new QueryWrapper<>();
        wrapper.setEntity(condition);
        return apiManager.pageApiInfo(p, wrapper);
    }

    @ApiOperation(value = "添加接口信息")
    @ApiOperationSupport(
            ignoreParameters = {"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId"},
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "id"))
    )
    @PostMapping("/info")
    public Object apiInfo(@RequestBody OpenapiApiInfo entity) {
        return ResponseProxy.r(apiManager.addApiInfo(entity), entity.getId());
    }

    @ApiOperation("添加接口请求参数信息")
    @ApiOperationSupport(
            ignoreParameters = {"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.apiId"},
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "id"))
    )
    @PostMapping("/requestParams/{apiId}")
    public Object addApiRequestParams(@PathVariable String apiId, @RequestBody OpenapiApiRequestParams entity) {
        return ResponseProxy.r(apiManager.addApiRequestParams(entity, apiId), entity.getId());
    }

    @ApiOperation("添加接口返回参数信息")
    @ApiOperationSupport(
            ignoreParameters = {"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.apiId"},
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "id"))
    )
    @PostMapping("/responseParams/{apiId}")
    public Object addApiResponseParams(@PathVariable String apiId, @RequestBody OpenapiApiResponseParams entity) {
        return ResponseProxy.r(apiManager.addApiResponseParams(entity, apiId), entity.getId());
    }

    @ApiOperation("修改接口请求参数信息")
    @ApiOperationSupport(
            ignoreParameters = {"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.apiId"},
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @PutMapping("/requestParams/{id}")
    public boolean updateApiRequestParams(@PathVariable String id, @RequestBody OpenapiApiRequestParams entity) {

        return apiManager.updateApiRequestParams(entity, id);
    }

    @ApiOperation("修改接口返回参数信息")
    @ApiOperationSupport(
            ignoreParameters = {"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.apiId"},
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @PutMapping("/responseParams/{id}")
    public boolean updateApiResponseParams(@PathVariable String id, @RequestBody OpenapiApiResponseParams entity) {

        return apiManager.updateApiResponseParams(entity, id);
    }

    @ApiOperation("修改接口信息")
    @ApiOperationSupport(
            ignoreParameters = {"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId"},
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @PutMapping("/info/{id}")
    public boolean updateApiInfo(@PathVariable String id, @RequestBody OpenapiApiInfo entity) {

        return apiManager.updateApiInfo(entity, id);
    }

    @ApiOperation("接口信息")
    @GetMapping("/info/{id}")
    public OpenapiApiInfo apiInfo(@PathVariable String id) {

        return apiManager.getApiInfo(id);
    }

    @ApiOperation("接口请求参数信息列表")
    @GetMapping("/requestParams/{apiId}")
    public List<OpenapiApiRequestParams> getApiRequestParams(@PathVariable String apiId) {

        return apiManager.getApiRequestParams(apiId);
    }

    @ApiOperation("接口返回参数信息列表")
    @GetMapping("/responseParams/{apiId}")
    public List<OpenapiApiResponseParams> getApiResponseParams(@PathVariable String apiId) {

        return apiManager.getApiResponseParams(apiId);
    }

    @ApiOperation("接口信息详情(包含请求参数和返回参数)")
    @GetMapping("/{apiId}")
    public ApiInfoVO apiInfoDetail(@PathVariable String apiId) {

        return apiManager.getApiInfoDetail(apiId);
    }

    @ApiOperation("删除接口信息")
    @ApiOperationSupport(
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @DeleteMapping("/info/{id}")
    public boolean deleteApiInfo(@PathVariable String id) {

        return apiManager.deleteApiInfo(id);
    }

    @ApiOperation("删除接口请求参数信息")
    @ApiOperationSupport(
            responses = @DynamicResponseParameters(
                    properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class)
            )
    )
    @DeleteMapping("/requestParams/{id}")
    public boolean deleteApiRequestParams(@PathVariable String id) {

        return apiManager.deleteApiRequestParams(id);
    }

    @ApiOperation("删除接口返回参数信息")
    @ApiOperationSupport(
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @DeleteMapping("/responseParams/{id}")
    public boolean deleteApiResponseParams(@PathVariable String id) {

        return apiManager.deleteApiResponseParams(id);
    }


}
