package com.bizvane.openapi.business.config;


import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import com.google.common.base.Predicates;
import io.swagger.annotations.Api;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * @author wang.zeyan
 * 2019年4月19日
 */
@Configuration
@EnableSwagger2
@EnableKnife4j
@Import(BeanValidatorPluginsConfiguration.class)
public class Swagger2Config {

    @Bean
    public Docket dynamicApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("dynamicapi")
                .apiInfo(dynamicApiEndPointsInfo())
                .select()
                .apis(RequestHandlerSelectors.any())
                .paths(PathSelectors.ant("/business/manager/test/api/**"))
                .build();
    }

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("manager")
                .apiInfo(apiEndPointsInfo())
                .select()
                .apis(RequestHandlerSelectors.withClassAnnotation(Api.class))
                .paths(Predicates.not(PathSelectors.ant("/business/manager/test/api/**")))
                .apis(RequestHandlerSelectors.any())
                .paths(PathSelectors.any())
                .build();
    }

    private ApiInfo apiEndPointsInfo() {
        return new ApiInfoBuilder().title("Spring Boot REST API")
                .description("Bizvane OpenApi-Business-Manager REST API")
                .contact(new Contact("上海商帆信息科技有限公司", "www.bizvane.com", "1000@qq.com"))
                .license("bizvane")
                .version("1.0.0")
                .build();
    }

    private ApiInfo dynamicApiEndPointsInfo() {
        return new ApiInfoBuilder().title("Spring Boot REST API")
                .description("Bizvane OpenApi RESTful API")
                .contact(new Contact("上海商帆信息科技有限公司", "www.bizvane.com", "1000@qq.com"))
                .license("bizvane")
                .version("1.0.0")
                .build();
    }
}
