package com.bizvane.openapi.business.config;

import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

import com.bizvane.openapi.business.consts.CodeMessageConsts;
import com.bizvane.openapi.business.modules.business.entity.OpenapiBusinessMain;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.common.utils.Assert;

/**
 * 
 * @author wang.zeyan
 *  2019年4月22日
 */
public class SessionInterceptorAdapter implements WebRequestInterceptor {

	@Override
	public void preHandle(WebRequest request) throws Exception {
		Object businessMain = request.getAttribute("business", RequestAttributes.SCOPE_SESSION);
		Assert.notNull(businessMain, CodeMessageConsts.Business.BUSINESS_NOT_LOGIN);
		if(businessMain instanceof OpenapiBusinessMain) {
			OpenapiBusinessMain bm = (OpenapiBusinessMain) businessMain;
			ThreadBusiness.getCurrentBusiness().set(bm);
		}
	}

	@Override
	public void postHandle(WebRequest request, ModelMap model) throws Exception {
	}

	@Override
	public void afterCompletion(WebRequest request, Exception ex) throws Exception {
		ThreadBusiness.remove();
	}

	
}
