package com.bizvane.openapi.business;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.config.MybatisPlusConfig;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.api.vo.ApiInfoVO;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceManager;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import javassist.*;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.OperationBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingScannerPlugin;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spring.web.readers.operation.CachingOperationNameGenerator;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

import java.util.List;
import java.util.Set;

/**
 * @author wang.zeyan
 */
@Component
@Order(SwaggerPluginSupport.SWAGGER_PLUGIN_ORDER)
@Slf4j
public class ServiceApiListingScanner implements ApiListingScannerPlugin, ApplicationEventPublisherAware {

    @Autowired
    OpenapiServiceManager openapiServiceManager;

    @Autowired
    OpenapiApiManager openapiApiManager;

    @Autowired
    TypeResolver typeResolver;

    public static Set<String> classNameSet = Sets.newHashSet();


    @Override
    public List<ApiDescription> apply(DocumentationContext context) {

        if (!"dynamicapi".equals(context.getGroupName())) {
            return Lists.newArrayList();
        }

        final List<ApiDescription> list = Lists.newArrayList();
        try {
            MybatisPlusConfig.tableFilter = true;

            openapiServiceManager.pagePublicService(new Page<OpenapiServiceInfo>(1, 1000).setSearchCount(false)).getRecords().forEach(
                    service -> {
                        openapiServiceManager.listServiceApi(service.getId()).forEach(
                                api -> {
                                    ApiInfoVO apiInfoDetail = openapiApiManager.getApiInfoDetail(api.getId());
                                    List<Parameter> paramsList = Lists.newArrayList();

                                    if (apiInfoDetail.getApiRequestParams() != null) {
                                        List<String> itemModel = Lists.newArrayList();
                                        apiInfoDetail.getApiRequestParams().forEach(
                                                rp -> {
                                                    Parameter headerParameter = new ParameterBuilder().type(new TypeResolver().resolve(String.class))
                                                            .name("bizvane-request-business-id")
                                                            .description("CRM企业ID")
                                                            .modelRef(new ModelRef("string"))
                                                            .parameterType("header")
                                                            .parameterAccess("access")
                                                            .required(true)
                                                            .defaultValue("")
                                                            .build();
                                                    paramsList.add(headerParameter);

                                                    if (!"body".equalsIgnoreCase(rp.getRequestType())) {
                                                        Parameter parameter = new ParameterBuilder().type(new TypeResolver().resolve(String.class))
                                                                .name(rp.getName())
                                                                .modelRef(new ModelRef("string"))
                                                                .parameterType(rp.getRequestType())
                                                                .parameterAccess("access")
                                                                .defaultValue("")
                                                                .build();
                                                        paramsList.add(parameter);
                                                    } else {
                                                        itemModel.add(rp.getName());
                                                    }
                                                }
                                        );
                                        if (itemModel.size() > 0) {
                                            String className = service.getAlias() + api.getAlias();
                                            className = className.replaceAll("\\-", "");
                                            ResolvedType resolve = null;
                                            if (!classNameSet.contains(className)) {
                                                resolve = typeResolver.resolve(createRefModel(className, itemModel));
                                                context.getAdditionalModels().add(resolve);
                                                classNameSet.add(className);
                                            } else {
                                                try {
                                                    resolve = typeResolver.resolve(Class.forName("com.bizvane.openapi.business.modelref." + className));
                                                } catch (ClassNotFoundException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                    /*String className =  service.getAlias() + api.getAlias();
                                    className  = className.replaceAll("\\-", "");
                                    ResolvedType resolve = typeResolver.resolve(createRefModel(className, itemModel));
                                    context.getAdditionalModels().add(resolve);*/
                                            Parameter parameter = new ParameterBuilder().type(resolve)
                                                    .name("entity")
                                                    .modelRef(new ModelRef(className))
                                                    .parameterType("body")
                                                    .required(true)
                                                    .parameterAccess("access")
                                                    .build();
                                            paramsList.add(parameter);

                                        }
                                    }

                                    ApiDescription apiDescription = new ApiDescription("dynamicapi", String.format("/business/manager/test/api/%s/%s/exec", api.getId(), service.getAlias()), null,
                                            Lists.newArrayList(
                                                    new OperationBuilder(new CachingOperationNameGenerator())
                                                            .method(HttpMethod.POST)
                                                            .consumes(Sets.newHashSet(MediaType.APPLICATION_JSON_VALUE))
                                                            .produces(Sets.newHashSet(MediaType.APPLICATION_JSON_UTF8_VALUE))
                                                            .summary(api.getName())
                                                            .responseMessages(
                                                                    Sets.newHashSet(
                                                                            new ResponseMessageBuilder().code(200).message("OK").responseModel(new ModelRef("map")).build()
                                                                    )
                                                            )
                                                            .uniqueId(service.getAlias() + api.getAlias())
                                                            .responseModel(new ModelRef("map"))
                                                            .tags(Sets.newHashSet(service.getName()))
                                                            .parameters(paramsList).build()
                                            ),
                                            true
                                    );
                                    list.add(apiDescription);
                                }
                        );
                    }
            );
        } finally {
            MybatisPlusConfig.tableFilter = false;
        }

        return list;

    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private ApplicationEventPublisher publisher;

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    private Class createRefModel(String alias, List<String> propertys) {
        ClassPool pool = ClassPool.getDefault();
        CtClass ctClass = pool.makeClass("com.bizvane.openapi.business.modelref." + alias);

        try {
            for (int i = 0; i < propertys.size(); i++) {
                ctClass.addField(createField(propertys.get(i), ctClass));
            }
            ConstPool constPool = ctClass.getClassFile().getConstPool();
            AnnotationsAttribute attr = new AnnotationsAttribute(constPool, AnnotationsAttribute.visibleTag);
            Annotation annotation = new Annotation("io.swagger.annotations.ApiModel", constPool);
            attr.addAnnotation(annotation);
            ctClass.getClassFile().addAttribute(attr);
            ctClass.addInterface(pool.makeInterface("java.io.Serializable"));

            return ctClass.toClass();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private CtField createField(String property, CtClass ctClass) throws NotFoundException, CannotCompileException {

        CtField ctField = new CtField(ClassPool.getDefault().get(String.class.getName()), property, ctClass);
        ctField.setModifiers(Modifier.PUBLIC);

        ConstPool constPool = ctClass.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, AnnotationsAttribute.visibleTag);
        Annotation annotation = new Annotation("io.swagger.annotations.ApiModelProperty", constPool);
        //annotation.addMemberValue("value", new StringMemberValue("", constPool));
        //annotation.addMemberValue("example", new StringMemberValue("", constPool));
        attr.addAnnotation(annotation);
        ctField.getFieldInfo().addAttribute(attr);

        return ctField;
    }
}
