package ${package.Controller};

import java.io.Serializable;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.bizvane.openapi.common.response.ResponseProxy;
import ${package.Entity}.${entity};
import ${package.Service}.${table.serviceName};
import io.swagger.annotations.Api;
import com.bizvane.openapi.common.response.Response;


/**
 * <p>
 * ${table.comment!} 前端控制器
 * </p>
 *
 * @author ${author}
 * @since ${date}
 */
@Api(tags = "${table.comment!}接口")
@RestController
@RequestMapping("/${package.ModuleName}/${table.entityPath}")
public class ${table.controllerName} {
	
	@Autowired
	${table.serviceName} ${table.entityPath}Service;
	
	/**
     * 列表
     */
	@GetMapping("/list")
    public Object list(
    		@RequestParam(defaultValue = "1") Long page, 
    		@RequestParam(defaultValue = "10") Long size, 
    		String [] ascs, 
    		String [] descs, 
    		${entity} condition){
    	Page<${entity}> p = new Page<>(page, size);
		if(ArrayUtils.isNotEmpty(ascs)) {
			p.setAsc(ascs);
		}
		if(ArrayUtils.isNotEmpty(descs)) {
			p.setDesc(descs);	
		}
    	QueryWrapper<${entity}> wrapper = new QueryWrapper<>();
    	wrapper.setEntity(condition);
        return ${table.entityPath}Service.page(p, wrapper);
    }
    
    /**
     * 信息
     */
    @GetMapping("/{id}")
    public Object info(@PathVariable Serializable id){
        return ${table.entityPath}Service.save(entity);
    }

    /**
     * 保存
     */
    @PostMapping
    public Object save(@RequestBody ${entity} entity){
		return ResponseProxy.r(${table.entityPath}Service.save(entity));
    }

    /**
     * 修改
     */
    @PutMapping
    public Object update(@RequestBody ${entity} entity){
		return ResponseProxy.r(${table.entityPath}Service.updateById(entity));
    }

    /**
     * 删除
     */
    @DeleteMapping("/{ids}")	
    public Object delete(@PathVariable List<Serializable> ids){
		return ResponseProxy.r(${table.entityPath}Service.removeByIds(ids));
    }
}
