# 开放平台文档

UAT环境swagger-ui地址
* [开放平台-网关](https://openapi.bizvane.cn/swagger-ui.html)`https://openapi.bizvane.cn/swagger-ui.html`
* [开放平台-商户管理](http://192.168.2.51:2002/doc.html)`http://192.168.2.51:2002/doc.html`


## 开放平台 服务端 接入流程说明

1. 创建商户 (提供商户账号 与 密码)
2. 商户登陆
3. 申请成为服务者( 返回开发者账号信息: appKey, appSecret)
4. 添加接口  (接口的alias不可重名)
5. 创建服务  (可先不创建服务, 服务名的alias不可重名)
6. 保存服务-接口关系 (可先不创建服务)
7. 接口测试
8. 服务端验证签名
9. 验证通过,返回结果

### 签名验证过程

开放平台请求后端服务时,将会在header中携带以下信息:
* bizvane-request-business-id   请求的商户号
* bizvane-signature  请求签名
* bizvane-signature-headers 参与签名的header
* bizvane-appkey  服务提供商的appkey
* b3  spring-cloud-zipkkin链路trace
* bizvane-request-id 请求id(zipkkin trace)
* bizvane-timestamp 请求时间戳
* bizvane-nonce 随机数

example
```
header:
{
    "bizvane-reuqest-business-id":"499dc0b0b46cbe83ed261ef6427c08b9",
    "bizvane-signature":"f552a268c60daaf23840cc39b672f16b",
    "bizvane-signature-headers":"bizvane-appkey,bizvane-nonce,bizvane-timestamp",
    "bizvane-appkey":"aba9728d6e1e48f996a3f6f92821bd4b",
    "b3":"42c23f18d32a8b64-7a46e38dc4754b8b-0-42c23f18d32a8b64",
    "bizvane-request-id":"42c23f18d32a8b64",
    "bizvane-timestamp":1559549778794,
    "bizvane-nonce":"yyvKuJOR"
}
body:
{
    "name":"张三",
    "alias":"zhangsan"
}

```

1. 本地存储 服务者 appkey 与 appsecret
2. 获取 bizvane-appkey 与本地 appkey 比较
3. 从header中获取参与签名的属性, 获取bizvane-signature-headers值
4. 将body + 参与签名的header + bizvane-appsecret(本地appsecret) 按ascii码排序 组装为原始字符串 rawData
```
alias=zhangsan&bizvane-appkey=aba9728d6e1e48f996a3f6f92821bd4b&bizvane-appsecret=76e2bb7b4a029395af04c7df412398b5&bizvane-nonce=ZTYDDrfQ&bizvane-timestamp=1559550644557&name=张三
```
5. 使用DigestUtils.md5Hex(ENCODER.encode(rawData.getBytes())) 获得签名
6. 将得到的签名与 header中的bizvane-signature 比较 签名是否正确




## 开放平台 客户端 接入流程说明
1. 创建商户 (提供商户账号 与 密码)
2. 商户登陆
3. 申请成为开发者( 返回开发者账号信息: appKey, appSecret)
4. 客户端请求接口, 接口地址规则为 POST http://openapi.bizvane.cn/request/{serviceAlias}/{apiAlias}


### 客户端请求 签名过程

客户端请求开放平台时,需在header中携带以下信息:
* bizvane-access-token  通过appkey 与 appSecret 获取access-token
* bizvane-nonce 随机字符串
* bizvane-timestamp 时间戳
* bizvane-signature 签名
* bizvane-appkey appkey 



1. 通过appkey和appSecret获取token

`http://openapi.bizvane.cn/oauth2/accessToken`

curl example
```
curl -X POST "http://openapi.bizvane.cn/oauth2/accessToken" -H "accept: */*" -H "Content-Type: application/json" -d "{ \"appKey\": \"c1eb385acac04e1a863f131bd1cc1b18\", \"appSecret\": \"7de79941a4a93a98a8f2d5114ac9e8e9\"}"
```
```
body:
{
    "appKey":"c1eb385acac04e1a863f131bd1cc1b18",
    "appSecret":"7de79941a4a93a98a8f2d5114ac9e8e9"
}
```
返回:
```
{
  "accessToken": "b9cf4fe4ce814f389b62dab02d481541",   
  "refreshToken": "2a36c7ac849485d0c420c99896e26434",
  "expiresIn": 7200     //过期时间,单位 秒
}
```

2. 将header内容 与 body内容 并加上bizvane-appsecret(appSecret值)按ascii码排序 组装为原始字符串 rawData, (appSecret 请勿传输)

```
alias=zhangsan&bizvane-access-token=69cb8c31ab94485ca8331a9f1e5911db&bizvane-appsecret=7de79941a4a93a98a8f2d5114ac9e8e9&bizvane-nonce=JCvUuJqk&bizvane-timestamp=1559628563403&name=张三
```

3. 将原始字符串rawData 先使用Base64.encode, 随后将该返回 md5摘要签名
```
byte [] encode = java.util.Base64.getEncoder().encode(rawData.getBytes());
String md5Digest = DigestUtils.md5Hex(encode);
```

4. 将摘要签名放入header中, header name: `bizvane-signature`

example
```
header:
{
    "bizvane-access-token":"cada3fedd7544c4e9f19ea0c862b36eb",
    "bizvane-nonce":"JCvUuJqk",
    "bizvane-appkey": "c1eb385acac04e1a863f131bd1cc1b18",
    "bizvane-timestamp":1559619697268,
    "bizvane-signature":"8c8cb4ebf445bc1e2a4dca94778b16f7"
}
body:
{
    "name":"张三",
    "alias":"zhangsan"
}
```

## 开放平台 错误反馈 说明



错误返回example:

http status code: 400 
```
header:
{
    "bizvane-request-id": "2d84ef57b4d7997e" 
}
body:
{
    "timestamp": "2020-03-13T01:50:36.513+0000",
    "path": "/request/service/api",
    "status": 400,
    "error": "Bad Request",
    "message": "Invalid.AccessToken"
}

```

http status code: 500
```
header:
{
    "bizvane-request-id": "2d84ef57b4d7997e" 
}
body:
{
    "timestamp": "2020-03-13T01:50:36.513+0000",
    "path": "/request/service/api",
    "status": 500,
    "error": "Sever Error",
    "message": "AppSecret.Don'tMatch "
}
```

* http状态码`4xx`为客户端错误, http状态码`5xx`为服务端错误, 
* bizvane-request-id 为请求ID, 可通过该ID查找,开放平台请求日志,甚至 接口服务方日志
* message 为错误描述


[错误码地址](https://openapi.bizvane.cn/error/all): `https://openapi.bizvane.cn/error/all`