/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business.modules.test.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.config.MybatisPlusConfig;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApi;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiManager;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiRequestParamsService;
import com.bizvane.openapi.common.response.Response;
import com.bizvane.openapi.common.response.ResponseProxy;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@Api(tags={"\u6d4b\u8bd5\u63a5\u53e3\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/business/manager/test/api/{apiId}"})
public class OpenapiTestApiControllerInfo {
    @Autowired
    OpenapiTestApiManager testApiManager;
    @Autowired
    OpenapiTestApiRequestParamsService testApiRequestParamsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4e3a\u5355\u4e2a\u63a5\u53e3\u6dfb\u52a0\u6d4b\u8bd5\u4fe1\u606f")
    @PostMapping
    public Object addTestApiInfo(@PathVariable String apiId, @RequestBody OpenapiTestApi entity) {
        MybatisPlusConfig.tableFilter = true;
        try {
            Object object = ResponseProxy.r((boolean)this.testApiManager.addTest(entity, apiId));
            return object;
        }
        finally {
            MybatisPlusConfig.tableFilter = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6267\u884c\u6d4b\u8bd5")
    @PostMapping(value={"/{serviceAlias}/exec"})
    public Object exec(@PathVariable String serviceAlias, @PathVariable String apiId, @RequestBody Map<String, Object> params, @RequestHeader(value="bizvane-request-business-id") String businessId) {
        MybatisPlusConfig.skipTableFilter.set(true);
        try {
            Object object = this.testApiManager.executeTest(apiId, params, businessId);
            return object;
        }
        finally {
            MybatisPlusConfig.skipTableFilter.remove();
        }
    }

    @ApiOperation(value="\u67e5\u770b\u5355\u4e2a\u63a5\u53e3\u4e0b\u7684\u6d4b\u8bd5\u5217\u8868")
    @GetMapping(value={"/list"})
    public Response list(@PathVariable String apiId, @RequestParam(defaultValue="1") Long page, @RequestParam(defaultValue="10") Long size, String[] ascs, String[] descs) {
        Page p = new Page(page.longValue(), size.longValue());
        if (ArrayUtils.isNotEmpty((Object[])ascs)) {
            p.setAsc(ascs);
        }
        if (ArrayUtils.isNotEmpty((Object[])descs)) {
            p.setDesc(descs);
        }
        return Response.ok((Object)this.testApiManager.pageTestApi(p, apiId));
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u63a5\u53e3\u4e0b\u6240\u4ee5\u6d4b\u8bd5\u4fe1\u606f")
    @DeleteMapping(value={"/all"})
    public Object deleteTestApi(@PathVariable String apiId) {
        return ResponseProxy.r((boolean)this.testApiManager.deleteAllTestApi(apiId));
    }
}

