/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business.modules.api.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiInfo;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiRequestParams;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiResponseParams;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiManager;
import com.bizvane.openapi.business.modules.api.vo.ApiInfoVO;
import com.bizvane.openapi.common.response.ResponseProxy;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicResponseParameters;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u63a5\u53e3\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/business/manager/api"})
public class OpenapiApiController {
    @Autowired
    OpenapiApiManager apiManager;

    @ApiOperation(value="\u63a5\u53e3\u5217\u8868")
    @GetMapping(value={"/list"})
    public IPage<OpenapiApiInfo> list(@RequestParam(defaultValue="1") Long page, @RequestParam(defaultValue="10") Long size, String[] ascs, String[] descs, OpenapiApiInfo condition) {
        Page p = new Page(page.longValue(), size.longValue());
        if (ArrayUtils.isNotEmpty((Object[])ascs)) {
            p.setAsc(ascs);
        }
        if (ArrayUtils.isNotEmpty((Object[])descs)) {
            p.setDesc(descs);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)condition);
        return this.apiManager.pageApiInfo(p, wrapper);
    }

    @ApiOperation(value="\u6dfb\u52a0\u63a5\u53e3\u4fe1\u606f")
    @ApiOperationSupport(ignoreParameters={"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId"}, responses=@DynamicResponseParameters(properties={@DynamicParameter(name="body", value="id")}))
    @PostMapping(value={"/info"})
    public Object apiInfo(@RequestBody OpenapiApiInfo entity) {
        return ResponseProxy.r((boolean)this.apiManager.addApiInfo(entity), (Object)entity.getId());
    }

    @ApiOperation(value="\u6dfb\u52a0\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4fe1\u606f")
    @ApiOperationSupport(ignoreParameters={"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.apiId"}, responses=@DynamicResponseParameters(properties={@DynamicParameter(name="body", value="id")}))
    @PostMapping(value={"/requestParams/{apiId}"})
    public Object addApiRequestParams(@PathVariable String apiId, @RequestBody OpenapiApiRequestParams entity) {
        return ResponseProxy.r((boolean)this.apiManager.addApiRequestParams(entity, apiId), (Object)entity.getId());
    }

    @ApiOperation(value="\u6dfb\u52a0\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4fe1\u606f")
    @ApiOperationSupport(ignoreParameters={"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.apiId"}, responses=@DynamicResponseParameters(properties={@DynamicParameter(name="body", value="id")}))
    @PostMapping(value={"/responseParams/{apiId}"})
    public Object addApiResponseParams(@PathVariable String apiId, @RequestBody OpenapiApiResponseParams entity) {
        return ResponseProxy.r((boolean)this.apiManager.addApiResponseParams(entity, apiId), (Object)entity.getId());
    }

    @ApiOperation(value="\u4fee\u6539\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4fe1\u606f")
    @ApiOperationSupport(ignoreParameters={"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.apiId"}, responses=@DynamicResponseParameters(properties={@DynamicParameter(name="body", value="\u6267\u884c\u7ed3\u679c", dataTypeClass=Boolean.class)}))
    @PutMapping(value={"/requestParams/{id}"})
    public boolean updateApiRequestParams(@PathVariable String id, @RequestBody OpenapiApiRequestParams entity) {
        return this.apiManager.updateApiRequestParams(entity, id);
    }

    @ApiOperation(value="\u4fee\u6539\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4fe1\u606f")
    @ApiOperationSupport(ignoreParameters={"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId", "entity.apiId"}, responses=@DynamicResponseParameters(properties={@DynamicParameter(name="body", value="\u6267\u884c\u7ed3\u679c", dataTypeClass=Boolean.class)}))
    @PutMapping(value={"/responseParams/{id}"})
    public boolean updateApiResponseParams(@PathVariable String id, @RequestBody OpenapiApiResponseParams entity) {
        return this.apiManager.updateApiResponseParams(entity, id);
    }

    @ApiOperation(value="\u4fee\u6539\u63a5\u53e3\u4fe1\u606f")
    @ApiOperationSupport(ignoreParameters={"entity.id", "entity.createTime", "entity.modifyTime", "entity.businessId"}, responses=@DynamicResponseParameters(properties={@DynamicParameter(name="body", value="\u6267\u884c\u7ed3\u679c", dataTypeClass=Boolean.class)}))
    @PutMapping(value={"/info/{id}"})
    public boolean updateApiInfo(@PathVariable String id, @RequestBody OpenapiApiInfo entity) {
        return this.apiManager.updateApiInfo(entity, id);
    }

    @ApiOperation(value="\u63a5\u53e3\u4fe1\u606f")
    @GetMapping(value={"/info/{id}"})
    public OpenapiApiInfo apiInfo(@PathVariable String id) {
        return this.apiManager.getApiInfo(id);
    }

    @ApiOperation(value="\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/requestParams/{apiId}"})
    public List<OpenapiApiRequestParams> getApiRequestParams(@PathVariable String apiId) {
        return this.apiManager.getApiRequestParams(apiId);
    }

    @ApiOperation(value="\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/responseParams/{apiId}"})
    public List<OpenapiApiResponseParams> getApiResponseParams(@PathVariable String apiId) {
        return this.apiManager.getApiResponseParams(apiId);
    }

    @ApiOperation(value="\u63a5\u53e3\u4fe1\u606f\u8be6\u60c5(\u5305\u542b\u8bf7\u6c42\u53c2\u6570\u548c\u8fd4\u56de\u53c2\u6570)")
    @GetMapping(value={"/{apiId}"})
    public ApiInfoVO apiInfoDetail(@PathVariable String apiId) {
        return this.apiManager.getApiInfoDetail(apiId);
    }

    @ApiOperation(value="\u5220\u9664\u63a5\u53e3\u4fe1\u606f")
    @ApiOperationSupport(responses=@DynamicResponseParameters(properties={@DynamicParameter(name="body", value="\u6267\u884c\u7ed3\u679c", dataTypeClass=Boolean.class)}))
    @DeleteMapping(value={"/info/{id}"})
    public boolean deleteApiInfo(@PathVariable String id) {
        return this.apiManager.deleteApiInfo(id);
    }

    @ApiOperation(value="\u5220\u9664\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4fe1\u606f")
    @ApiOperationSupport(responses=@DynamicResponseParameters(properties={@DynamicParameter(name="body", value="\u6267\u884c\u7ed3\u679c", dataTypeClass=Boolean.class)}))
    @DeleteMapping(value={"/requestParams/{id}"})
    public boolean deleteApiRequestParams(@PathVariable String id) {
        return this.apiManager.deleteApiRequestParams(id);
    }

    @ApiOperation(value="\u5220\u9664\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4fe1\u606f")
    @ApiOperationSupport(responses=@DynamicResponseParameters(properties={@DynamicParameter(name="body", value="\u6267\u884c\u7ed3\u679c", dataTypeClass=Boolean.class)}))
    @DeleteMapping(value={"/responseParams/{id}"})
    public boolean deleteApiResponseParams(@PathVariable String id) {
        return this.apiManager.deleteApiResponseParams(id);
    }
}

