package com.bizvane.openapi.business.modules.test.controller;

import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.consts.StringConsts;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApiHistory;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiHistoryService;
import com.bizvane.openapi.common.response.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import springfox.documentation.annotations.ApiIgnore;

/**
 * 
 * @author wang.zeyan
 *  2019年5月8日
 */
@ApiIgnore
@Api(tags = "测试接口测试历史")
@RestController
@RequestMapping("/business/manager/test/api/history/{testApiId}")
public class OpenapiTestApiHistoryController {

	
	@Autowired
	OpenapiTestApiHistoryService testApiHistoryService;
	
	@ApiOperation("单个接口分页历史记录")
	@GetMapping("/list")
    public Response list(
    		@PathVariable String testApiId,
    		@RequestParam(defaultValue = "1") Long page, 
    		@RequestParam(defaultValue = "10") Long size, 
    		String [] ascs, 
    		String [] descs){
    	Page<OpenapiTestApiHistory> p = new Page<>(page, size);
		if(ArrayUtils.isNotEmpty(ascs)) {
			p.setAsc(ascs);
		}
		if(ArrayUtils.isNotEmpty(descs)) {
			p.setDesc(descs);	
		}
		QueryWrapper<OpenapiTestApiHistory> wrapper = new QueryWrapper<OpenapiTestApiHistory>()
				.eq(StringConsts.TEST_API_ID, testApiId);
        return Response.ok(testApiHistoryService.page(p, wrapper));
    }
	
	@ApiOperation("单个接口最后一条测试记录")
	@GetMapping("/last")
    public Response last(
    		@PathVariable String testApiId){
		QueryWrapper<OpenapiTestApiHistory> wrapper = new QueryWrapper<OpenapiTestApiHistory>()
				.eq(StringConsts.TEST_API_ID, testApiId)
				.orderByDesc(StringConsts.CREATE_TIME);
        return Response.ok(testApiHistoryService.getOne(wrapper));
    }
}
