package com.bizvane.openapi.business.modules.test.controller;

import java.util.Map;

import com.bizvane.openapi.business.config.MybatisPlusConfig;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.test.entity.OpenapiTestApi;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiManager;
import com.bizvane.openapi.business.modules.test.service.OpenapiTestApiRequestParamsService;
import com.bizvane.openapi.common.response.Response;
import com.bizvane.openapi.common.response.ResponseProxy;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import springfox.documentation.annotations.ApiIgnore;

/**
 * 
 * @author wang.zeyan
 *  2019年5月8日
 */
@ApiIgnore
@Api(tags = "测试接口管理")
@RestController
@RequestMapping("/business/manager/test/api/{apiId}")
public class OpenapiTestApiControllerInfo {
	
	@Autowired
	OpenapiTestApiManager testApiManager;
	
	@Autowired
	OpenapiTestApiRequestParamsService testApiRequestParamsService;
	
	@ApiOperation("为单个接口添加测试信息")
	@PostMapping
	public Object addTestApiInfo(@PathVariable String apiId, @RequestBody OpenapiTestApi entity) {
		MybatisPlusConfig.tableFilter = true;
		try {
			return ResponseProxy.r(testApiManager.addTest(entity, apiId));
		} finally {
			MybatisPlusConfig.tableFilter = false;
		}
	}
	
	@ApiOperation("执行测试")
	@PostMapping("/{serviceAlias}/exec")
	public Object exec(@PathVariable String serviceAlias, @PathVariable String apiId, @RequestBody Map<String, Object> params, @RequestHeader("bizvane-request-business-id") String businessId) {
		MybatisPlusConfig.skipTableFilter.set(true);
		try {
			return testApiManager.executeTest(apiId, params, businessId);
		} finally {
			MybatisPlusConfig.skipTableFilter.remove();
		}
	}
	
	@ApiOperation("查看单个接口下的测试列表")
	@GetMapping("/list")
    public Response list(
    		@PathVariable String apiId,
    		@RequestParam(defaultValue = "1") Long page, 
    		@RequestParam(defaultValue = "10") Long size, 
    		String [] ascs, 
    		String [] descs){
    	Page<OpenapiTestApi> p = new Page<>(page, size);
		if(ArrayUtils.isNotEmpty(ascs)) {
			p.setAsc(ascs);
		}
		if(ArrayUtils.isNotEmpty(descs)) {
			p.setDesc(descs);	
		}
        return Response.ok(testApiManager.pageTestApi(p, apiId));
    }
	
	@ApiOperation("删除单个接口下所以测试信息")
	@DeleteMapping("/all")
	public Object deleteTestApi(@PathVariable String apiId) {
		return ResponseProxy.r(testApiManager.deleteAllTestApi(apiId));
	}
	
	/*@ApiOperation("删除单个接口下所以测试请求参数信息")
	@DeleteMapping("/params/all")
	public Response deleteTestApiRequestParams(@PathVariable String apiId) {
		return ResponseProxy.r(testApiManager.deleteTestApiRequestParamsByApiId(apiId));
	}*/
}