package com.bizvane.openapi.business.modules.service.controller;

import com.bizvane.openapi.business.modules.service.service.OpenapiServiceManager;
import com.bizvane.openapi.business.modules.service.vo.ServiceApiInfoVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicResponseParameters;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

/**
 * @author wang.zeyan
 * 2019年5月10日
 */
@Api(tags = "服务管理")
@RestController
@RequestMapping("/business/manager/service/{serviceId}")
public class OpenapiServiceApiController {

    @Autowired
    OpenapiServiceManager serviceManager;


    @ApiOperation("添加 服务-接口关系")
    @PostMapping("/{apiIds}")
    @ApiOperationSupport(
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @ApiImplicitParam(name = "apiIds", value = "接口id数组")
    public boolean addServiceApi(@PathVariable String serviceId, @PathVariable Set<String> apiIds) {

        return serviceManager.addServiceApi(serviceId, apiIds);
    }

    @ApiOperation("保存 服务-接口关系")
    @PutMapping("/{apiIds}")
    @ApiOperationSupport(
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @ApiImplicitParam(name = "apiIds", value = "接口id数组")
    public boolean saveServiceApi(@PathVariable String serviceId, @PathVariable Set<String> apiIds) {

        return serviceManager.saveServiceApi(serviceId, apiIds);
    }

    @ApiOperation("删除 服务-接口关系")
    @ApiOperationSupport(
            responses = @DynamicResponseParameters(properties = @DynamicParameter(name = "body", value = "执行结果", dataTypeClass = Boolean.class))
    )
    @DeleteMapping("/{apiIds}")
    public boolean deleteServiceApi(@PathVariable String serviceId, @PathVariable Set<String> apiIds) {

        return serviceManager.deleteServiceApi(serviceId, apiIds);
    }

    @ApiOperation("查询 服务-接口关系")
    @GetMapping("/apis")
    public List<ServiceApiInfoVO> getApisOfService(@PathVariable String serviceId) {

        return serviceManager.getServiceApi(serviceId);
    }
}
