package com.bizvane.openapi.business.modules.dynamicapi.controller;

import com.bizvane.openapi.common.response.ResponseProxy;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.spring.web.plugins.DocumentationPluginsBootstrapper;

/**
 * @author wang.zeyan
 */
@Api(tags = "接口文档刷新")
@RestController
@RequestMapping("/business/manager/refresh")
public class DynamicApiRefreshController {

    @Autowired
    DocumentationPluginsBootstrapper documentationPluginsBootstrapper;

    @ApiOperation("刷新接口")
    @GetMapping("/application/restart")
    public Object refresh() {

        documentationPluginsBootstrapper.stop();
        documentationPluginsBootstrapper.start();
        return ResponseProxy.r(true, "ok");
    }
}
