package com.bizvane.openapi.business.modules.developeraccount.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.developeraccount.entity.OpenapiDeveloperAccount;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;


/**
 * <p>
 * 开发者/服务者账号 前端控制器
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-04-23
 */
@Api(tags = "开发者&服务者账号接口")
@RestController
@RequestMapping("/business/manager/developerAccount")
public class OpenapiDeveloperAccountController {

    @Autowired
    OpenapiDeveloperAccountManager developerAccountManager;

    /**
     * 列表
     */
    @ApiOperation("列表")
    @GetMapping("/list")
    public IPage<OpenapiDeveloperAccount> list(
            @RequestParam(defaultValue = "1") Long page,
            @RequestParam(defaultValue = "10") Long size,
            String[] ascs,
            String[] descs,
            OpenapiDeveloperAccount condition) {
        Page<OpenapiDeveloperAccount> p = new Page<>(page, size);
        if (ArrayUtils.isNotEmpty(ascs)) {
            p.setAsc(ascs);
        }
        if (ArrayUtils.isNotEmpty(descs)) {
            p.setDesc(descs);
        }

        QueryWrapper<OpenapiDeveloperAccount> wrapper = new QueryWrapper<>();
        wrapper.setEntity(condition);
        return developerAccountManager.pageDeveloperAccount(p, wrapper);
    }

    /**
     * 信息
     */
    @ApiIgnore
    @GetMapping("/{id}")
    public OpenapiDeveloperAccount info(@PathVariable String id) {
        return developerAccountManager.get(id);
    }

    /**
     * 申请成为开发者
     */
    @ApiOperation("申请成为开发者")
    @PostMapping("/applyToDeveloper")
    public OpenapiDeveloperAccount applyToDeveloper() {
        return developerAccountManager.applyToDeveloper();
    }

    /**
     * 申请成为服务者
     *
     * @return
     */
    @ApiOperation("申请成为服务者")
    @PostMapping("/applyToProvider")
    public OpenapiDeveloperAccount applyToProvider() {
        return developerAccountManager.applyToProvider();
    }

}
