package com.bizvane.openapi.business.modules.api.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.openapi.business.modules.api.entity.OpenapiApiExample;
import com.bizvane.openapi.business.modules.api.service.OpenapiApiExampleService;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.io.Serializable;
import java.util.List;


/**
 * <p>
 * 接口示例 前端控制器
 * </p>
 *
 * @author wang.zeyan
 * @since 2019-07-02
 */
@ApiIgnore
@Api(tags = "接口示例接口")
@RestController
@RequestMapping("/business/manager/api/openapiApiExample")
public class OpenapiApiExampleController {

    @Autowired
    OpenapiApiExampleService openapiApiExampleService;

    /**
     * 列表
     */
    @GetMapping("/list")
    public IPage<OpenapiApiExample> list(
            @RequestParam(defaultValue = "1") Long page,
            @RequestParam(defaultValue = "10") Long size,
            String[] ascs,
            String[] descs,
            OpenapiApiExample condition) {
        Page<OpenapiApiExample> p = new Page<>(page, size);
        if (ArrayUtils.isNotEmpty(ascs)) {
            p.setAsc(ascs);
        }
        if (ArrayUtils.isNotEmpty(descs)) {
            p.setDesc(descs);
        }
        QueryWrapper<OpenapiApiExample> wrapper = new QueryWrapper<>();
        wrapper.setEntity(condition);
        return openapiApiExampleService.page(p, wrapper);
    }

    /**
     * 信息
     */
    @GetMapping("/{id}")
    public OpenapiApiExample info(@PathVariable Serializable id) {
        return openapiApiExampleService.getById(id);
    }

    /**
     * 保存
     */
    @PostMapping
    public boolean save(@RequestBody OpenapiApiExample entity) {
        return openapiApiExampleService.save(entity);
    }

    /**
     * 修改
     */
    @PutMapping
    public boolean update(@RequestBody OpenapiApiExample entity) {
        return openapiApiExampleService.updateById(entity);
    }

    /**
     * 删除
     */
    @DeleteMapping("/{ids}")
    public boolean delete(@PathVariable List<Serializable> ids) {
        return openapiApiExampleService.removeByIds(ids);
    }
}
