package com.bizvane.openapi.business.config;


import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.ISqlParserFilter;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.extension.parsers.BlockAttackSqlParser;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantSqlParser;
import com.bizvane.openapi.business.utils.ThreadBusiness;
import com.bizvane.openapi.business.utils.ThreadSystem;
import com.google.common.collect.Lists;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * @author wang.zeyan
 * 2019年4月22日
 */
@Configuration
@MapperScan({"com.bizvane.openapi.business.modules.*.mapper"})
public class MybatisPlusConfig {


    public volatile static boolean tableFilter;

    public static ThreadLocal<Boolean> skipTableFilter = new ThreadLocal<Boolean>();

    /**
     * 分页插件
     */
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();

        List<ISqlParser> sqlParserList = Lists.newArrayList();
        TenantSqlParser tenantSqlParser = new TenantSqlParser();
        tenantSqlParser.setTenantHandler(new TenantHandler() {

            @Override
            public String getTenantIdColumn() {
                return "business_id";
            }

            @Override
            public Expression getTenantId() {
                return new StringValue(ThreadBusiness.getCurrentBusinessId());
            }

            @Override
            public boolean doTableFilter(String tableName) {
                if (tableFilter) {
                    return true;
                }
                if (skipTableFilter.get() != null && skipTableFilter.get().booleanValue() == true) {
                    return true;
                }
                if ("openapi_business_main".equals(tableName)) {
                    return true;
                }
                return false;
            }
        });
        sqlParserList.add(tenantSqlParser);

        sqlParserList.add(new BlockAttackSqlParser());
        paginationInterceptor.setSqlParserList(sqlParserList);
        paginationInterceptor.setSqlParserFilter(new ISqlParserFilter() {

            @Override
            public boolean doFilter(MetaObject metaObject) {
                if (ThreadSystem.isSystem()) {
                    return true;
                }
                MappedStatement ms = SqlParserHelper.getMappedStatement(metaObject);
                String id = ms.getId();
                if (id.endsWith("insert")) {
                    return true;
                }
                return false;
            }
        });
        return paginationInterceptor;
    }
}
