/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.business.shell;

import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.nacos.api.exception.NacosException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.alibaba.nacos.NacosConfigProperties;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ShellComponent
public class RuleCommands {
    @Autowired
    NacosConfigProperties nacos;
    public static final String FLOW_DATA_ID_POSTFIX = "-flow-rules";
    public static final String PARAM_FLOW_DATA_ID_POSTFIX = "-param-rules";
    public static final String SYSTEM_DATA_ID_POSTFIX = "-system-rules";
    public static final String AUTHORITY_DATA_ID_POSTFIX = "-authority-rules";
    public static final String DEGRADE_DATA_ID_POSTFIX = "-degrade-rules";

    @ShellMethod(value="\u6dfb\u52a0\u9ed1\u767d\u540d\u5355\u89c4\u5219")
    public boolean addAuthorityRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName, @ShellOption(help="\u8d44\u6e90\u540d\u79f0") String resourceName, @ShellOption(help="\u540d\u5355") String[] limitApp, @ShellOption(help="\u6a21\u5f0f", value={"0 (\u767d\u540d\u5355) 1 (\u9ed1\u540d\u5355)"}, defaultValue="0") int strategy) throws NacosException {
        String dataId = appName + AUTHORITY_DATA_ID_POSTFIX;
        List rules = this.getAuthorityRuleOfNacos(appName);
        if (rules != null) {
            for (int i = 0; i < rules.size(); ++i) {
                AuthorityRule rule = (AuthorityRule)rules.get(i);
                if (!resourceName.equals(rule.getResource()) || rule.getStrategy() != strategy) continue;
                System.out.println("\u8d44\u6e90\u89c4\u5219\u5df2\u5b58\u5728");
                return false;
            }
        }
        if (rules == null) {
            rules = Lists.newArrayList();
        }
        AuthorityRule rule = new AuthorityRule();
        rule.setResource(resourceName);
        rule.setLimitApp(Joiner.on((String)",").join((Object[])limitApp));
        rule.setStrategy(strategy);
        rules.add(rule);
        boolean b = this.nacos.configServiceInstance().publishConfig(dataId, this.nacos.getGroup(), JSON.toJSONString((Object)rules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        return b;
    }

    @ShellMethod(value="\u5220\u9664\u9ed1\u767d\u540d\u5355\u89c4\u5219")
    public boolean removeAuthorityRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName, @ShellOption(help="\u8d44\u6e90\u540d\u79f0", defaultValue="") String resourceName, @ShellOption(help="\u6a21\u5f0f", value={"0 (\u767d\u540d\u5355) 1 (\u9ed1\u540d\u5355)"}, defaultValue="0") int strategy) throws NacosException {
        String dataId = appName + AUTHORITY_DATA_ID_POSTFIX;
        List rules = this.getAuthorityRuleOfNacos(appName);
        if (StringUtils.hasText((String)resourceName)) {
            Iterator iterator = rules.iterator();
            while (iterator.hasNext()) {
                AuthorityRule rule = (AuthorityRule)iterator.next();
                if (!resourceName.equals(rule.getResource()) || rule.getStrategy() != strategy) continue;
                iterator.remove();
                break;
            }
            if (CollectionUtils.isEmpty((Collection)rules)) {
                return this.nacos.configServiceInstance().removeConfig(dataId, this.nacos.getGroup());
            }
            return this.nacos.configServiceInstance().publishConfig(dataId, this.nacos.getGroup(), JSON.toJSONString((Object)rules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        }
        return this.nacos.configServiceInstance().removeConfig(dataId, this.nacos.getGroup());
    }

    @ShellMethod(value="\u67e5\u770b\u9ed1\u767d\u540d\u5355\u89c4\u5219")
    public String getAuthorityRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName, @ShellOption(help="\u8d44\u6e90\u540d\u79f0", defaultValue="") String resourceName, @ShellOption(help="\u6a21\u5f0f", value={"0 (\u767d\u540d\u5355) 1 (\u9ed1\u540d\u5355)"}, defaultValue="-1") int strategy) throws NacosException {
        List rules = this.getAuthorityRuleOfNacos(appName);
        ArrayList result = Lists.newArrayList();
        if (StringUtils.hasText((String)resourceName)) {
            for (int i = 0; i < rules.size(); ++i) {
                AuthorityRule rule = (AuthorityRule)rules.get(i);
                if (!resourceName.equals(rule.getResource())) continue;
                if (strategy == -1) {
                    result.add(rule);
                }
                if (rule.getStrategy() != strategy) continue;
                return JSON.toJSONString((Object)rule, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            }
            if (strategy == -1) {
                return JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            }
        }
        return JSON.toJSONString((Object)rules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    @ShellMethod(value="\u6dfb\u52a0\u7cfb\u7edf\u4fdd\u62a4\u89c4\u5219")
    public boolean addSystemRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName, @ShellOption(help="\u7cfb\u7edf\u8d1f\u8f7d", defaultValue="-1.0") BigDecimal systemLoad, @ShellOption(help="cpu\u4f7f\u7528\u7387(0.6 = 60%)", defaultValue="-1.0") BigDecimal cpuUsage, @ShellOption(help="\u7cfb\u7edf\u6700\u5927qps", defaultValue="-1") int qps, @ShellOption(help="\u6700\u5927\u5e76\u884c\u7ebf\u7a0b", defaultValue="-1") int maxThread, @ShellOption(help="\u5e73\u5747rt(\u5355\u4f4dms)", defaultValue="-1") int avgRt) throws NacosException {
        List rules = this.getSystemRuleOfNacos(appName);
        if (rules != null) {
            System.out.println("\u89c4\u5219\u5df2\u5b58\u5728");
            return false;
        }
        rules = Lists.newArrayList();
        SystemRule rule = new SystemRule();
        rule.setHighestSystemLoad(systemLoad.doubleValue());
        rule.setHighestCpuUsage(cpuUsage.doubleValue());
        rule.setAvgRt((long)avgRt);
        rule.setQps((double)qps);
        rule.setMaxThread((long)maxThread);
        rules.add(rule);
        boolean b = this.nacos.configServiceInstance().publishConfig(appName + SYSTEM_DATA_ID_POSTFIX, this.nacos.getGroup(), JSON.toJSONString((Object)rules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        return b;
    }

    @ShellMethod(value="\u5220\u9664\u7cfb\u7edf\u4fdd\u62a4\u89c4\u5219")
    public boolean removeSystemRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName) throws NacosException {
        return this.nacos.configServiceInstance().removeConfig(appName, this.nacos.getGroup());
    }

    @ShellMethod(value="\u67e5\u770b\u7cfb\u7edf\u4fdd\u62a4\u89c4\u5219")
    public String getSystemRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName) throws NacosException {
        List rules = this.getSystemRuleOfNacos(appName);
        return JSON.toJSONString((Object)rules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    @ShellMethod(value="\u4fee\u6539\u7cfb\u7edf\u4fdd\u62a4\u89c4\u5219")
    public boolean editSystemRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName, @ShellOption(help="\u7cfb\u7edf\u8d1f\u8f7d", defaultValue="-2.0") BigDecimal systemLoad, @ShellOption(help="cpu\u4f7f\u7528\u7387(0.6 = 60%)", defaultValue="-2.0") BigDecimal cpuUsage, @ShellOption(help="\u7cfb\u7edf\u6700\u5927qps", defaultValue="-2") int qps, @ShellOption(help="\u6700\u5927\u5e76\u884c\u7ebf\u7a0b", defaultValue="-2") int maxThread, @ShellOption(help="\u5e73\u5747rt(\u5355\u4f4dms)", defaultValue="-2") int avgRt) throws NacosException {
        String dataId = appName + SYSTEM_DATA_ID_POSTFIX;
        List rules = this.getSystemRuleOfNacos(appName);
        if (rules == null) {
            System.out.println("\u89c4\u5219\u4e0d\u5b58\u5728");
            return false;
        }
        SystemRule rule = (SystemRule)rules.get(0);
        if (!"-2.0".equals(systemLoad)) {
            rule.setHighestSystemLoad(systemLoad.doubleValue());
        }
        if (!"-2.0".equals(cpuUsage)) {
            rule.setHighestCpuUsage(cpuUsage.doubleValue());
        }
        if (qps != -2) {
            rule.setQps((double)qps);
        }
        if (maxThread != -2) {
            rule.setMaxThread((long)maxThread);
        }
        if (avgRt != -2) {
            rule.setAvgRt((long)avgRt);
        }
        boolean b = this.nacos.configServiceInstance().publishConfig(dataId, this.nacos.getGroup(), JSON.toJSONString((Object)rules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        return b;
    }

    @ShellMethod(value="\u6dfb\u52a0\u6d41\u91cf\u63a7\u5236\u89c4\u5219")
    public boolean addFlowRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName, @ShellOption(help="\u8d44\u6e90\u540d\u79f0") String resourceName, @ShellOption(help="\u9650\u6d41\u9600\u503c") int count, @ShellOption(help="\u9650\u6d41\u9600\u503c\u7c7b\u578b, \u9ed8\u8ba4\u4e3a QPS", value={"0 (Thread)", "1 (QPS)"}, defaultValue="1") int grade, @ShellOption(help="\u6d41\u63a7\u9488\u5bf9\u7684\u8c03\u7528\u6765\u6e90\uff0cdefault \u5219\u4e0d\u533a\u5206\u8c03\u7528\u6765\u6e90", defaultValue="default") String limitApp, @ShellOption(help="\u6d41\u91cf\u63a7\u5236\u6548\u679c", value={"0 (\u76f4\u63a5\u62d2\u7edd)", "1 (\u51b7\u542f\u52a8)", "2 (\u5300\u901f\u6392\u961f)"}, defaultValue="0") int controlBehavior) throws NacosException {
        List rules = this.getFlowRuleOfNacos(appName);
        if (rules == null) {
            rules = Lists.newArrayList();
        }
        for (int i = 0; i < rules.size(); ++i) {
            FlowRule rule = (FlowRule)rules.get(i);
            if (!resourceName.equals(rule.getResource())) continue;
            System.out.println("\u8d44\u6e90\u5df2\u5b58\u5728");
            return false;
        }
        FlowRule rule = new FlowRule(resourceName);
        rule.setCount((double)count);
        rule.setGrade(grade);
        rule.setLimitApp(limitApp);
        rule.setControlBehavior(controlBehavior);
        rules.add(rule);
        boolean b = this.nacos.configServiceInstance().publishConfig(appName + FLOW_DATA_ID_POSTFIX, this.nacos.getGroup(), JSON.toJSONString((Object)rules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        return b;
    }

    @ShellMethod(value="\u67e5\u770b\u6d41\u91cf\u63a7\u5236\u89c4\u5219")
    public String getFlowRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName, @ShellOption(help="\u8d44\u6e90\u540d\u79f0", defaultValue="") String resourceName) throws NacosException {
        List rules = this.getFlowRuleOfNacos(appName);
        if (StringUtils.hasText((String)resourceName)) {
            for (int i = 0; i < rules.size(); ++i) {
                FlowRule rule = (FlowRule)rules.get(i);
                if (!resourceName.equals(rule.getResource())) continue;
                return JSON.toJSONString((Object)rule, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            }
        }
        return JSON.toJSONString((Object)rules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    @ShellMethod(value="\u5220\u9664\u6d41\u91cf\u63a7\u5236\u89c4\u5219")
    public boolean removeFlowRule(@ShellOption(help="\u5e94\u7528\u540d\u79f0") String appName, @ShellOption(help="\u8d44\u6e90\u540d\u79f0", defaultValue="") String resourceName) throws NacosException {
        String dataId = appName + FLOW_DATA_ID_POSTFIX;
        List rules = this.getFlowRuleOfNacos(appName);
        if (StringUtils.hasText((String)resourceName)) {
            Iterator iterator = rules.iterator();
            while (iterator.hasNext()) {
                FlowRule rule = (FlowRule)iterator.next();
                if (!resourceName.equals(rule.getResource())) continue;
                iterator.remove();
                break;
            }
            boolean b = this.nacos.configServiceInstance().publishConfig(dataId, this.nacos.getGroup(), JSON.toJSONString((Object)rules, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return b;
        }
        boolean b = this.nacos.configServiceInstance().removeConfig(dataId, this.nacos.getGroup());
        return b;
    }

    private List<AuthorityRule> getAuthorityRuleOfNacos(String appName) throws NacosException {
        return (List)this.getRuleList(appName, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, appName + AUTHORITY_DATA_ID_POSTFIX);
    }

    private List<FlowRule> getFlowRuleOfNacos(String appName) throws NacosException {
        return (List)this.getRuleList(appName, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, appName + FLOW_DATA_ID_POSTFIX);
    }

    private List<SystemRule> getSystemRuleOfNacos(String appName) throws NacosException {
        return (List)this.getRuleList(appName, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, appName + SYSTEM_DATA_ID_POSTFIX);
    }

    private <T> T getRuleList(String appName, TypeReference<T> type, String dataId) throws NacosException {
        String result = this.nacos.configServiceInstance().getConfig(dataId, this.nacos.getGroup(), 5000L);
        if (result == null) {
            return null;
        }
        return (T)JSON.parseObject((String)result, type, (Feature[])new Feature[0]);
    }
}

