/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.authentication;

import com.bizvane.openapi.authentication.AuthenticationService;
import com.bizvane.openapi.authentication.consts.CodeMessageConsts;
import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.authentication.vo.Token;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.common.utils.GeneratorUtils;
import com.bizvane.openapi.common.utils.SignatureUtils;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.redisson.RedissonMapCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    static final String CACHE_CLIENT_DETAIL = "client_detail";
    static final String CACHE_ACCESS_TOKEN = "access_token";
    static final String CACHE_ACCESS_TOKEN_CLIENT = "access_token_client";
    static final String CACHE_REFRESH_TOKEN = "refresh_token";
    static final String CACHE_CLIENT_TOKEN = "client_token";
    static final String CACHE_REFRESH_TOKEN_CLIENT = "refresh_token_client";
    static final String EXPIRESIN_EL = "${spring.cache.redis.caches.access_token.ttl:${spring.cache.redis.timeToLive:-1}}";
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${spring.cache.redis.caches.access_token.ttl:${spring.cache.redis.timeToLive:-1}}")
    private Duration expiresIn;

    @Override
    public <T extends Client> void cacheClient(T client) {
        this.cacheManager.getCache(CACHE_CLIENT_DETAIL).put((Object)client.getAppKey(), client);
    }

    @Override
    public Client getClient(String accessToken) {
        return (Client)this.cacheManager.getCache(CACHE_ACCESS_TOKEN_CLIENT).get((Object)accessToken, Client.class);
    }

    @Override
    public Client getClientWithAppKey(String appKey) {
        Assert.hasText((String)appKey, (CodeMessage)CodeMessageConsts.Authentication.APP_KEY_EMPTY);
        return (Client)this.cacheManager.getCache(CACHE_CLIENT_DETAIL).get((Object)appKey, Client.class);
    }

    @Override
    public Token accessToken(String appKey, String appSecret) {
        Assert.hasText((String)appKey, (CodeMessage)CodeMessageConsts.Authentication.APP_KEY_EMPTY);
        Assert.hasText((String)appSecret, (CodeMessage)CodeMessageConsts.Authentication.APP_SECRET_EMPTY);
        Client client = this.getClientWithAppKey(appKey);
        Assert.notNull((Object)client, (CodeMessage)CodeMessageConsts.Authentication.INVALID_APP_KEY);
        Assert.hasText((String)client.getAppSecret(), (CodeMessage)CodeMessageConsts.Authentication.INVALID_APP_KEY);
        Assert.isTrue((boolean)appSecret.equals(client.getAppSecret()), (CodeMessage)CodeMessageConsts.Authentication.APPKEY_APPSECRET_MISMATCH);
        return Optional.ofNullable(this.getClientToken(appKey)).orElseGet(() -> this.generateTokenAndCache(client));
    }

    @Override
    public Token accessToken(Client client) {
        Assert.notNull((Object)client, (CodeMessage)CodeMessageConsts.Authentication.APP_KEY_EMPTY);
        Assert.hasText((String)client.getAppKey(), (CodeMessage)CodeMessageConsts.Authentication.APP_KEY_EMPTY);
        Assert.hasText((String)client.getAppSecret(), (CodeMessage)CodeMessageConsts.Authentication.APP_SECRET_EMPTY);
        Token token = this.getClientToken(client.getAppKey());
        return token == null ? this.generateTokenAndCache(client) : token;
    }

    @Override
    public Token refreshToken(String appKey, String refreshToken) {
        Assert.hasText((String)appKey, (CodeMessage)CodeMessageConsts.Authentication.APP_KEY_EMPTY);
        Client client = (Client)this.cacheManager.getCache(CACHE_REFRESH_TOKEN_CLIENT).get((Object)refreshToken, Client.class);
        Assert.notNull((Object)client, (CodeMessage)CodeMessageConsts.Authentication.INVALID_REFRESH_TOKEN);
        Assert.isTrue((boolean)appKey.equals(client.getAppKey()), (CodeMessage)CodeMessageConsts.Authentication.INVALID_APP_KEY);
        Token tokenInCache = (Token)this.cacheManager.getCache(CACHE_REFRESH_TOKEN).get((Object)refreshToken, Token.class);
        if (tokenInCache != null) {
            Object cache;
            Object accessToken = this.cacheManager.getCache(CACHE_ACCESS_TOKEN).getNativeCache();
            if (accessToken instanceof RedissonMapCache) {
                RedissonMapCache mapCache = (RedissonMapCache)accessToken;
                mapCache.put((Object)tokenInCache.getAccessToken(), (Object)tokenInCache, 60L, TimeUnit.SECONDS);
            }
            if ((cache = this.cacheManager.getCache(CACHE_ACCESS_TOKEN_CLIENT).getNativeCache()) instanceof RedissonMapCache) {
                RedissonMapCache mapCache = (RedissonMapCache)cache;
                mapCache.put((Object)tokenInCache.getAccessToken(), (Object)client, 60L, TimeUnit.SECONDS);
            }
        }
        this.cacheEvict(refreshToken, CACHE_REFRESH_TOKEN_CLIENT, CACHE_REFRESH_TOKEN);
        Token token = this.generateTokenAndCache(client);
        return token;
    }

    @Override
    public boolean verifySignature(String sign, String accessToken, Map<String, Object> params) {
        Assert.hasText((String)accessToken, (CodeMessage)CodeMessageConsts.Authentication.INVALID_ACCESS_TOKEN);
        Assert.hasText((String)sign, (CodeMessage)CodeMessageConsts.Authentication.SIGNATRUE_EMPTY);
        Assert.notEmpty(params, (CodeMessage)CodeMessageConsts.Authentication.PARAMS_EMPTY);
        Client client = (Client)this.cacheManager.getCache(CACHE_ACCESS_TOKEN_CLIENT).get((Object)accessToken, Client.class);
        Assert.notNull((Object)client, (CodeMessage)CodeMessageConsts.Authentication.INVALID_ACCESS_TOKEN);
        return SignatureUtils.verifySign((String)client.getAppSecret(), params, (String)sign);
    }

    @Override
    public String signature(String appKey, Map<String, Object> params) {
        Assert.hasText((String)appKey, (CodeMessage)CodeMessageConsts.Authentication.APP_KEY_EMPTY);
        Client client = (Client)this.cacheManager.getCache(CACHE_CLIENT_DETAIL).get((Object)appKey, Client.class);
        Assert.notNull((Object)client, (CodeMessage)CodeMessageConsts.Authentication.INVALID_APP_KEY);
        return SignatureUtils.sign((String)client.getAppSecret(), params);
    }

    private void cacheToken(Token token, Client client) {
        this.cacheManager.getCache(CACHE_ACCESS_TOKEN).put((Object)token.getAccessToken(), (Object)token);
        this.cacheManager.getCache(CACHE_ACCESS_TOKEN_CLIENT).put((Object)token.getAccessToken(), (Object)client);
        this.cacheManager.getCache(CACHE_REFRESH_TOKEN).put((Object)token.getRefreshToken(), (Object)token);
        this.cacheManager.getCache(CACHE_REFRESH_TOKEN_CLIENT).put((Object)token.getRefreshToken(), (Object)client);
    }

    private Token generateTokenAndCache(Client client) {
        Token token = this.generateToken(client.getAppKey(), client.getAppSecret());
        this.cacheToken(token, client);
        this.cacheClientToken(client.getAppKey(), token);
        return token;
    }

    private Token getClientToken(String appKey) {
        Token token = (Token)this.cacheManager.getCache(CACHE_CLIENT_TOKEN).get((Object)appKey, Token.class);
        if (token == null) {
            return null;
        }
        Object cache = this.cacheManager.getCache(CACHE_CLIENT_TOKEN).getNativeCache();
        if (cache instanceof RedissonMapCache) {
            RedissonMapCache mapCache = (RedissonMapCache)cache;
            long remainTimeToLive = mapCache.remainTimeToLive((Object)appKey);
            token.setExpiresIn(Math.abs(remainTimeToLive) / 1000L);
        }
        return token;
    }

    private void cacheClientToken(String appKey, Token token) {
        this.cacheManager.getCache(CACHE_CLIENT_TOKEN).put((Object)appKey, (Object)token);
    }

    private void cacheEvict(String key, String ... namespaces) {
        if (ArrayUtils.isEmpty((Object[])namespaces)) {
            return;
        }
        for (int i = 0; i < namespaces.length; ++i) {
            this.cacheManager.getCache(namespaces[i]).evict((Object)key);
        }
    }

    @Override
    public Client generateClient() {
        String appKey = GeneratorUtils.uuid();
        String appSecret = GeneratorUtils.md5DigestAsHex((String)appKey);
        Client client = new Client(appKey, appSecret);
        return client;
    }

    private Token generateToken(String appKey, String appSecret) {
        String accessToken = GeneratorUtils.uuid();
        String refreshToken = GeneratorUtils.md5DigestAsHex((String)accessToken);
        Token token = new Token();
        token.setAccessToken(accessToken);
        token.setRefreshToken(refreshToken);
        token.setExpiresIn(this.expiresIn.getSeconds());
        return token;
    }
}

