package com.bizvane.openapifacade.models.vo;

import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

public class CouponResponseVO {

    /**
     * 券号
     */
    private String thqNO;

    /**
     * 券名
     */
    private String thqName;

    /**
     * 券编号
     */
    private String couponCode;

    /**
     * 批次号
     */
    private Long thqId;

    /**
     * 开始日期yyyy-MM-dd
     */
    private String startDate;

    /**
     * 结束日期yyyy-MM-dd
     */
    private String endDate;

    /**
     * 门店编号
     */
    private String scope;

    /**
     * 备注
     */
    private String ms;

    /**
     * 卡号
     */
    private String CardCode;

    /**
     * 手机号
     */
    private String MobileTel;

    /**
     * 使用金额
     */
    private BigDecimal Amount;

    /**
     * 门店信息
     */
    private String ShopList;

    /**
     * 是否以正价为前提 （0-特价，1-正价，2-正特价）
     */
    private Integer IsSpecialOffer;

    /**
     * 商品数量最低限制
     */
    private Integer  MinQty;

    /**
     * 商品数量最高限制
     */
    private Integer  MaxQty;

    /**
     * 最低消费 
     */
    private BigDecimal MinAmount;

    /**
     * 是否叠加促销(0-不叠加，1-叠加)
     */
    private Byte noStackPromotion;

    /**
     * 是否叠加券
     */
    private Byte noStackCardNo;

    private String  isactive;

    private String  isuse;

    /**
     *  "effectiveDays": 30, 有效时间，例：30天 ，90天
     */
    private String effectiveDays;

    private  String info;
    
    private Long couponDefinitionId;

    @ApiModelProperty(name = "preferentialType", value = "优惠类型：现金=1,折扣=2,兑换=3", required = false, example = "")
    private Byte preferentialType;

    @ApiModelProperty(value = "优惠券售卖金额", name = "couponSaleAmount")
    private BigDecimal couponSaleAmount;

    @ApiModelProperty(value = "券类型号,对应中间库TYPE_CODE", name = "typeCode")
    private String typeCode;

    @ApiModelProperty(value = "是否适用全国门店,对应中间库ISALLSTORE,Y/N", name = "applyAllStore")
    private String applyAllStore;

    @ApiModelProperty(value = "员工券类型员工ID,对应中间库staff_id", name = "staffId")
    private String couponStaffId;

    @ApiModelProperty(value = "品牌ID", name = "brandId")
    private Long brandId;

    @ApiModelProperty(value = "发券方式", name = "sendType")
    private String sendType;

    @ApiModelProperty(value = "发券方式信息", name = "sendTypeMsg")
    private String sendTypeMsg;

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getCardCode() {
        return CardCode;
    }

    public void setCardCode(String cardCode) {
        CardCode = cardCode;
    }

    public String getMobileTel() {
        return MobileTel;
    }

    public void setMobileTel(String mobileTel) {
        MobileTel = mobileTel;
    }

    public BigDecimal getAmount() {
        return Amount;
    }

    public void setAmount(BigDecimal amount) {
        Amount = amount;
    }

    public String getShopList() {
        return ShopList;
    }

    public void setShopList(String shopList) {
        ShopList = shopList;
    }

    public Integer getIsSpecialOffer() {
        return IsSpecialOffer;
    }

    public void setIsSpecialOffer(Integer isSpecialOffer) {
        IsSpecialOffer = isSpecialOffer;
    }

    public Integer getMinQty() {
        return MinQty;
    }

    public void setMinQty(Integer minQty) {
        MinQty = minQty;
    }

    public Integer getMaxQty() {
        return MaxQty;
    }

    public void setMaxQty(Integer maxQty) {
        MaxQty = maxQty;
    }

    public BigDecimal getMinAmount() {
        return MinAmount;
    }

    public void setMinAmount(BigDecimal minAmount) {
        MinAmount = minAmount;
    }

    public Byte getNoStackPromotion() {
        return noStackPromotion;
    }

    public void setNoStackPromotion(Byte noStackPromotion) {
        this.noStackPromotion = noStackPromotion;
    }

    public Byte getNoStackCardNo() {
        return noStackCardNo;
    }

    public void setNoStackCardNo(Byte noStackCardNo) {
        this.noStackCardNo = noStackCardNo;
    }

    public String getThqNO() {
        return thqNO;
    }

    public void setThqNO(String thqNO) {
        this.thqNO = thqNO;
    }

    public String getThqName() {
        return thqName;
    }

    public void setThqName(String thqName) {
        this.thqName = thqName;
    }

    public Long getThqId() {
        return thqId;
    }

    public void setThqId(Long thqId) {
        this.thqId = thqId;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getMs() {
        return ms;
    }

    public void setMs(String ms) {
        this.ms = ms;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getIsactive() {
        return isactive;
    }

    public void setIsactive(String isactive) {
        this.isactive = isactive;
    }

    public String getIsuse() {
        return isuse;
    }

    public void setIsuse(String isuse) {
        this.isuse = isuse;
    }

    public String getEffectiveDays() {
        return effectiveDays;
    }

    public void setEffectiveDays(String effectiveDays) {
        this.effectiveDays = effectiveDays;
    }

		public Long getCouponDefinitionId() {
			return couponDefinitionId;
		}

		public void setCouponDefinitionId(Long couponDefinitionId) {
			this.couponDefinitionId = couponDefinitionId;
		}

    public void setPreferentialType(Byte preferentialType) {
        this.preferentialType = preferentialType;
    }

    public Byte getPreferentialType() {
        return preferentialType;
    }

    public void setCouponSaleAmount(BigDecimal couponSaleAmount) {
        this.couponSaleAmount = couponSaleAmount;
    }

    public BigDecimal getCouponSaleAmount() {
        return couponSaleAmount;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setApplyAllStore(String applyAllStore) {
        this.applyAllStore = applyAllStore;
    }

    public String getApplyAllStore() {
        return applyAllStore;
    }

    public void setCouponStaffId(String couponStaffId) {
        this.couponStaffId = couponStaffId;
    }

    public String getCouponStaffId() {
        return couponStaffId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setSendType(String sendType) {
        this.sendType = sendType;
    }

    public String getSendType() {
        return sendType;
    }

    public void setSendTypeMsg(String sendTypeMsg) {
        this.sendTypeMsg = sendTypeMsg;
    }

    public String getSendTypeMsg() {
        return sendTypeMsg;
    }
}
