package com.bizvane.openapifacade.models.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;

/**
 * 券详情查询vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年08月29日 12:06:00
 */
@Data
public class CommonCouponInfoReqVo implements Serializable {

    @NotEmpty
    private String couponCode;

    /**
     * 按会员信息更新时间查询时的开始时间
     */
    private Date startTime;

    /**
     * 按会员信息更新时间查询时的结束时间
     */
    private Date endTime;

    private Integer pageNo = 1;

    private Integer pageSize = 10;

}
