package com.bizvane.openapifacade.models.vo;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class Order361RequestVo {


    private Long sysCompanyId;//非openApi接口字段 attention!!!


    @NotNull
    private String brandCode;//		是	string	品牌id
    @NotNull
    private Integer orderFlag;//		是	string	1是订单2是退单
    @NotNull
    private String phone;//		是	string	会员手机号
    @NotNull
    private String erpId;//		是	string	会员唯一标识(类似于主键id、会员code、costomerCode等)
    @NotNull
    private String orderNo;//		是	string	订单号

    private String sourceCode; //来源渠道code
    @NotNull
    private Integer orderFrom;//		是	int	订单来源 : 1.POS(门店) 2.商城
    private Integer shopWay;//		否	string	购物方式,1：快递,2：自提,3：预约
    private String fetchStoreCode;//		否	string	自提门店Code
    private BigDecimal preferentialAmount;//		否	decimal	优惠券优惠金额
    private BigDecimal deductibleAmount;    //	否	decimal	积分抵扣金额
    private BigDecimal commodityAmount;//		否	decimal	商品金额 成交总额
    private BigDecimal tradeAmount;//		否	decimal	成交金额(优惠卷+抵扣卷+打折)
    private BigDecimal otherPreferentialVolume;//		否	decimal	其他优惠卷金额(满减 满包邮)
    @NotNull
    private Date placeOrderTime;//		否	dateTime	下单时间
    private Integer placeOrderCount;//		否	int	下单数量
    private Date payTime;//		否	dateTime	支付时间
    private BigDecimal payMoney;//		否	decimal	支付金额
    private Integer usedIntegral;//		否	int	使用积分
    private Integer productCount;//		否	int	商品数量(发货数量)
    private String consigneeAddress;//		否	string	收货人的信息地址
    private String consigneePhone;//		否	string	收货人的手机
    private String consigneeName;    //	否	string	收货人的姓名信息
    private String consigneeDetailed;//		否	string	收货人的详细地址
    private String consigneeProvince;//		否	string	收货人的省份
    private String consigneeCity;//		否	string	收货人的城市
    private String consigneeArea;//		否	string	收货人的区
    private String consigneeStreet;//		否	string	收货人的街道号
    private Date comfirmTime;//		否	dateTime	确认收货时间
    private Integer deliveredCount;//		否	int	已发货数量
    private Integer freePostage;//		否	int	是否包邮1:包邮,2自费
    private BigDecimal postage;//		否	decimal	邮费(不包邮应收金额)
    private Date sendTime;//		否	dateTime	发货时间
    private String orgCode;//		否	string	361消费渠道码                 ????
    private String storeCode;//		否	string	店铺Code
    private String storeName;//		否	string	店铺名称
    private String guideCodes;        //否	string	店铺服务导购Code
    private String guideNames;//	否	string	店铺导购名称
    private Date cancelOrderTime;//		否	dateTime	取消订单时间
    private String sendStore;//		否	string	发货门店
    private String invoiceNo;//		否	string	发票号
    private BigDecimal invoiceMoney;//		否	decimal	发票金额


    private String originalOrderNo;//原始订单


    private String noExecIntegral;//		否	int	是否加积分0：加；1：不加,不传默认加

    private List<OrderUsedCouponVo> couponInfo;//		否	string	关联优惠券


    private List<OrderUsedDetailVo> orderDetail;//		否	string	关联订单明细

    private List<OrderUsedPaymentVo> orderPayMent;//		否	string	关联支付明细

    private String buyerRemark;//		否	string	买家备注
    private String remark;//		否	string	备注

}
