package com.bizvane.openapifacade.models.vo.webhook;

import com.bizvane.openapifacade.utils.valid.EnumStringValue;
import com.bizvane.openapifacade.utils.valid.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotBlank;


/**
 * webhook用 积分调整请求参数
 */
@Data
public class IntegralAdjustVo {

    /**
     * 品牌code
     */
    @NotBlank(message = "品牌code不能为空")
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;

    /**
     * 变更积分数 如果是扣减 则为负数
     */
    @NotBlank(message = "变更积分数量不能为空")
    private String changeIntegral;

    /**
     * 会员卡号
     */
//    @NotBlank(message = "会员卡号不能为空")
    private String cardNo;

    /**
     * 换成手机号
     */
//    @NotBlank(message = "手机号不能为空")
//    private String phone;

    /**
     * 变更说明
     */
    private String changeRemark;

    /**
     * 店铺Code
     */
    private String storeCode;
}
