package com.bizvane.openapifacade.models.vo;

import com.bizvane.openapifacade.utils.valid.EnumStringValue;
import com.bizvane.openapifacade.utils.valid.StringBrandCode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.format.annotation.DateTimeFormat;


import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author sampson
 * @Date 2021-01-26 14:49
 * @Describe
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class VGOrderRequestVO {
    /**
     * 俱乐部code
     */
    @NotBlank(message = "品牌code不能为空")
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;
    /**
     * 1是订单 2是退单 3换货单
     */
    @Min( value=1 )
    @Max( value=4 )
    @NotNull( message="订单类型不允许为空，1-订单，2-是退单，3-非VG换货单,4-VG换货单" )
    private Integer orderFlag;
    /**
     * 会员卡号
     */
//    @NotBlank(message = "会员卡号不允许为空")
    private String cardNo;
    /**
     * 订单号
     */
    @NotBlank(message = "订单号不允许为空")
    private String orderNo;
    /**
     * 订单来源
     * 1 门店
     * 2 集团商城
     * 3 天猫
     * 4 有赞
     */
    @Min( value=1 )
    @Max( value=4 )
    @NotNull(message = "订单来源不允许为空")
    private Integer orderFrom;
    /**
     * 下单时间
     */
    @Past( message="不能超过当前时间" )
    @DateTimeFormat( pattern="yyyy-MM-dd HH:mm:ss" )
    @NotNull( message="下单时间不允许格式不对,eg: 2020-01-01 10:00:00" )
    private Date placeOrderTime;
    /**
     * 手机号
     */
    private String phone;
    /**
     * 原订单号(只有退单时，才需要传值)
     * 若不传，不退积分
     */
    private String originalOrderNo;
    /**
     * 订单当前等级
     */
    private String currentLevelCode;
    /**
     * 吊牌价
     * SUM，吊牌价（商品吊牌价 * 购买数量）
     */
    @NotNull(message = "吊牌价不允许为空")
    private BigDecimal commodityAmount;
    /**
     * SUM，实际价格（折扣价 * 购买数量）
     */
    @NotNull(message = "实际价格不允许为空")
    private BigDecimal tradeAmount;
    /**
     * 优惠券优惠金额,抵扣金额
     */
    private BigDecimal preferentialAmount;
    /**
     * 积分抵扣金额
     */
    private BigDecimal deductibleAmount;
    /**
     * 其他优惠金额（满减 满包邮）
     */
    private BigDecimal otherPreferentialAmount;
    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 单据时间
     */
    private Date billTime;
    /**
     * 支付金额（退单为负值）
     * 程序一定要根据orderFlag来判断
     */
    private BigDecimal payMoney;
    /**
     * 使用积分
     */
    private Integer usedIntegral;
    /**
     * 获得积分数量
     */
    private Integer getIntegral;
    /**
     * 商品数量(发货数量)
     */
    @NotNull(message = "商品数量不允许为空")
    private Integer productCount;
    /**
     * 发货时间
     */
    private Date sendTime;
    /**
     * 线下店铺Code
     * 通过Code给 storeName，serviceStoreId 赋值
     */
    private String storeCode;
    /**
     * 关联优惠券
     */
    private List<VGOrderUsedCouponVO> couponInfos;
    /**
     * 关联订单明细
     */
    private List<VGOrderUsedDetailVO> orderDetails;
    /**
     * 关联支付明细
     */
    private List<VGOrderUsedPaymentVO> orderPayMents;
    /**
     * 买家备注
     */
    private String buyerRemark;
    /**
     * 备注
     */
    private String remark;

    /**
     * 导购id ，以逗号隔开
     */
    private String orderGuideIds;
    /**
     * 导购名称
     */
    private String orderGuideNames;
    /**
     * 新增以下字段企业id
     */
    private Long sysCompanyId ;
    /**
     * 店铺名称
     */
    private String storeName ;
    /**
     * 线下店铺地址
     */
    private String serviceStoreSite ;

    /**
     * 实现深拷贝
     *
     * @return
     */
    public VGOrderRequestVO deepCopy() {
        VGOrderRequestVO vo = new VGOrderRequestVO();
        BeanUtils.copyProperties(this, vo);
        List<VGOrderUsedDetailVO> thisDetails = this.getOrderDetails();
        if (thisDetails != null && thisDetails.size() > 0) {
            List<VGOrderUsedDetailVO> detailVOList = new ArrayList<>();
            for (int i = 0; i < thisDetails.size(); ++i) {
                VGOrderUsedDetailVO detailVO = new VGOrderUsedDetailVO();
                BeanUtils.copyProperties(thisDetails.get(i), detailVO);
                detailVOList.add(detailVO);
            }
            vo.setOrderDetails(detailVOList);
        }
        List<VGOrderUsedCouponVO> thisCoupons = this.getCouponInfos();
        if (thisCoupons != null && thisCoupons.size() > 0) {
            List<VGOrderUsedCouponVO> couponVOList = new ArrayList<>();
            for (int i = 0; i < couponVOList.size(); ++i) {
                VGOrderUsedCouponVO couponVO = new VGOrderUsedCouponVO();
                BeanUtils.copyProperties(couponVOList.get(i), couponVO);
                thisCoupons.add(couponVO);
            }
            vo.setCouponInfos(couponVOList);
        }
        return vo;
    }
}
