package com.bizvane.openapifacade.models.vo;

import com.bizvane.openapifacade.utils.valid.EnumStringValue;
import com.bizvane.openapifacade.utils.valid.StringBrandCode;
import com.bizvane.openapifacade.utils.valid.ValidConstants;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Date;

@Data
public class OpenCardRequestVo {
    @NotEmpty
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;
    @NotEmpty
//    @Pattern(regexp = "^[1][2,3,4,5,6,7,8,9][0-9]{9}$", message = ValidConstants.PHONE_ERROR_MESSAGE)
    private String phone;
    private String cardNo;
    private String name;
    /**
     * 性别 : 1.女 2.男
     */
    //@Pattern(regexp="^[1-2]{1}$",message=ValidConstants.SEX_ERROR_MESSAGE)
    private Integer sex;
    private String province;
    private String city;
    private String county;
    private String address;
    private String remark;
    private String email;
    private String idCard;
    private String birthday;
    private String storeCode;
    private String levelCode;
    private String guideCode;
    @NotNull
    private Integer source;
    private Integer points;
    private String unionId;
    private Integer valid;
//    String addinterfaceAll1 = "openCard,燕之屋会员开卡,/openapi.api/yanzhiwu/member/openCard";
//    String addParamList11 = "brandCode,品牌code&phone,手机号&cardNo,会员卡号&name,会员名称&sex,性别&province,省&city,市&county,区&address,会员详细地址&remark,备注&email,会员邮箱&idCard,会员身份证&birthday,会员生日&storeCode,注册门店&guideCode,注册导购&levelCode,会员等级code&source,会员注册渠道&points,可用积分&unionId,微信unionId&valid,会员卡状态&erpId,会员唯一标志";
//    String addinterfaceAll2 = "memberQuery,燕之屋会员查询,/openapi.api/yanzhiwu/member/queryMember";
//    String addParamList12 = "brandCode,品牌code&erpId,会员唯一标志&phone,手机号&wxUnionId,会员unionId";
    private Long sysCompanyId;
    private Date openCardTime;
    private String userId;
}
